/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.listener;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.MiniMessage;
import not.savage.airheads.AirHeadEntity;
import not.savage.airheads.AirHeadsPlugin;
import not.savage.airheads.shade.com.github.retrooper.packetevents.event.PacketListener;
import not.savage.airheads.shade.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import not.savage.airheads.shade.com.github.retrooper.packetevents.event.UserLoginEvent;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PacketInterceptListener
implements PacketListener {
    private final AirHeadsPlugin plugin;
    private final String PLAYER_TAG = "%player%";

    public PacketInterceptListener(AirHeadsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onUserLogin(@NotNull UserLoginEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> CompletableFuture.runAsync(() -> this.plugin.getPacketEntityCache().showWorld((Player)event.getPlayer())), 5L);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.INTERACT_ENTITY) {
            return;
        }
        WrapperPlayClientInteractEntity packet = new WrapperPlayClientInteractEntity(event);
        int entityId = packet.getEntityId();
        AirHeadEntity airHead = this.plugin.getPacketEntityCache().getEntityByEntityId(entityId);
        if (airHead != null) {
            event.setCancelled(true);
            Player player = (Player)event.getPlayer();
            this.syncExecute(player, airHead, packet.getAction());
        }
    }

    private void syncExecute(Player player, AirHeadEntity airHead, WrapperPlayClientInteractEntity.InteractAction action) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (action == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                this.handleLeftClick(player, airHead);
            }
            if (action == WrapperPlayClientInteractEntity.InteractAction.INTERACT || action == WrapperPlayClientInteractEntity.InteractAction.INTERACT_AT) {
                this.handleRightClick(player, airHead);
            }
            airHead.getConfig().getInteractSettings().getInteractCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)player, (String)cmd.replace("%player%", player.getName())));
            airHead.getConfig().getInteractSettings().getConsoleCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%player%", player.getName())));
            if (!airHead.getConfig().getInteractSettings().getInteractMessage().isEmpty()) {
                airHead.getConfig().getInteractSettings().getInteractMessage().forEach(line -> player.sendMessage(MiniMessage.miniMessage().deserialize(line)));
            }
            this.playInteractSound(player, airHead);
            this.trySendConnectMessage(player, airHead);
        });
    }

    private void handleLeftClick(Player player, AirHeadEntity airHead) {
        airHead.getConfig().getInteractSettings().getLeftClickCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)player, (String)cmd.replace("%player%", player.getName())));
        airHead.getConfig().getInteractSettings().getLeftClickConsoleCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%player%", player.getName())));
    }

    private void handleRightClick(Player player, AirHeadEntity airHead) {
        airHead.getConfig().getInteractSettings().getRightClickCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)player, (String)cmd.replace("%player%", player.getName())));
        airHead.getConfig().getInteractSettings().getRightClickConsoleCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%player%", player.getName())));
    }

    private void playInteractSound(Player player, AirHeadEntity airHead) {
        if (airHead.getConfig().getInteractSettings().getSoundSettings().isEnabled() && airHead.getConfig().getInteractSettings().getSoundSettings().sound() != null) {
            player.playSound((Entity)player, airHead.getConfig().getInteractSettings().getSoundSettings().sound(), airHead.getConfig().getInteractSettings().getSoundSettings().getVolume(), airHead.getConfig().getInteractSettings().getSoundSettings().getPitch());
        }
    }

    private void trySendConnectMessage(Player player, AirHeadEntity airHead) {
        if (!airHead.getConfig().getInteractSettings().getSendTo().isEmpty()) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            try {
                out.writeUTF("Connect");
                out.writeUTF(airHead.getConfig().getInteractSettings().getSendTo());
                player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
            }
            catch (Exception ignored) {
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)("<red>Error sending to server: " + airHead.getConfig().getInteractSettings().getSendTo() + ".")));
            }
        }
    }
}

