/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.pig;

import net.kyori.adventure.util.Index;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.pig.PigVariants;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.pig.StaticPigVariant;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBT;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import not.savage.airheads.shade.com.github.retrooper.packetevents.resources.ResourceLocation;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.adventure.AdventureIndexUtil;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface PigVariant
extends MappedEntity,
CopyableEntity<PigVariant>,
DeepComparableEntity {
    public ModelType getModelType();

    public ResourceLocation getAssetId();

    public static PigVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(PigVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, PigVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static PigVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String modelTypeString = compound.getStringTagValueOrNull("model");
        ModelType modelType = modelTypeString != null ? ModelType.getByName(modelTypeString) : ModelType.NORMAL;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticPigVariant(data, modelType, assetId);
    }

    public static NBT encode(PigVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("model", new NBTString(variant.getModelType().getName()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }

    public static enum ModelType {
        NORMAL("normal"),
        COLD("cold");

        private static final Index<String, ModelType> NAME_INDEX;
        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public static ModelType getByName(String name) {
            return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, name);
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_INDEX = Index.create(ModelType.class, ModelType::getName);
        }
    }
}

