/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.shade.com.github.retrooper.packetevents.util.updatechecker;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import net.kyori.adventure.text.format.NamedTextColor;
import not.savage.airheads.shade.com.github.retrooper.packetevents.PacketEvents;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.ColorUtil;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.PEVersion;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.adventure.AdventureSerializer;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker {
    public String checkLatestReleasedVersion() {
        try {
            URLConnection connection = new URL("https://api.github.com/repos/retrooper/packetevents/releases/latest").openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String jsonResponse = reader.readLine();
            reader.close();
            JsonObject jsonObject = (JsonObject)AdventureSerializer.serializer().gson().serializer().fromJson(jsonResponse, JsonObject.class);
            return jsonObject.get("name").getAsString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse packetevents version!", e);
        }
    }

    public UpdateCheckerStatus checkForUpdate() {
        PEVersion newVersion;
        PEVersion localVersion = PacketEvents.getAPI().getVersion();
        try {
            newVersion = PEVersion.fromString(this.checkLatestReleasedVersion());
        }
        catch (Exception ex) {
            PacketEvents.getAPI().getLogManager().warn("Failed to check for updates. " + (ex.getCause() != null ? ex.getCause().getClass().getName() + ": " + ex.getCause().getMessage() : ex.getMessage()));
            return UpdateCheckerStatus.FAILED;
        }
        if (localVersion.isOlderThan(newVersion)) {
            PacketEvents.getAPI().getLogManager().warn("There is an update available for PacketEvents! Your build: (" + ColorUtil.toString(NamedTextColor.YELLOW) + localVersion + ColorUtil.toString(NamedTextColor.WHITE) + ") | Latest release: (" + ColorUtil.toString(NamedTextColor.GREEN) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.OUTDATED;
        }
        if (localVersion.isNewerThan(newVersion)) {
            PacketEvents.getAPI().getLogManager().info("You are running a development build of PacketEvents. Your build: (" + ColorUtil.toString(NamedTextColor.AQUA) + localVersion + ColorUtil.toString(NamedTextColor.WHITE) + ") | Latest release: (" + ColorUtil.toString(NamedTextColor.DARK_AQUA) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.PRE_RELEASE;
        }
        if (localVersion.equals(newVersion)) {
            PacketEvents.getAPI().getLogManager().info("You are running the latest release of PacketEvents. Your build: (" + ColorUtil.toString(NamedTextColor.GREEN) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.UP_TO_DATE;
        }
        PacketEvents.getAPI().getLogManager().warn("Failed to check for updates. Your build: (" + localVersion + ")");
        return UpdateCheckerStatus.FAILED;
    }

    public void handleUpdateCheck(@Nullable Runnable updateCheckCallback) {
        Thread thread = new Thread(() -> {
            PacketEvents.getAPI().getLogManager().info("Checking for updates, please wait...");
            UpdateCheckerStatus status = this.checkForUpdate();
            if (updateCheckCallback != null) {
                updateCheckCallback.run();
            }
        }, "packetevents-update-check-thread");
        thread.start();
    }

    public void handleUpdateCheck() {
        this.handleUpdateCheck(null);
    }

    public static enum UpdateCheckerStatus {
        OUTDATED,
        PRE_RELEASE,
        UP_TO_DATE,
        FAILED;

    }
}

