/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.utility.adapter;

import java.lang.reflect.Type;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class NamespacedKeyAdapter
implements TypeSerializer<NamespacedKey> {
    public NamespacedKey deserialize(Type type, ConfigurationNode node) throws SerializationException {
        String namespaceKeyPair = node.getString();
        if (namespaceKeyPair == null) {
            throw new SerializationException("NamespacedKey must be a string");
        }
        String[] split = namespaceKeyPair.split(":");
        if (split.length < 2) {
            throw new SerializationException("NamespacedKey must be in the format of 'namespace:key'");
        }
        return new NamespacedKey(split[0], split[1]);
    }

    public void serialize(Type type, @Nullable NamespacedKey obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            throw new SerializationException("NamespacedKey cannot be null");
        }
        node.set((Object)obj.toString());
    }
}

