/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.tasks;

import not.savage.airheads.AirHeadEntity;
import org.bukkit.Location;
import org.bukkit.scheduler.BukkitRunnable;

public class AirHeadAnimationTask
extends BukkitRunnable {
    private final AirHeadEntity airHead;
    private final double minY;
    private final double maxY;
    private final double stepHeight;
    private final int rotationSpeed;
    private final long initialDelay;
    private int rot = -180;
    private boolean goingUp = true;

    public AirHeadAnimationTask(Location origin, AirHeadEntity airHead, long initialDelay) {
        this.airHead = airHead;
        this.minY = origin.getY() - airHead.getHead().getBoundingBox().expand(airHead.getConfig().getScale()).getHeight() - this.airHead.getConfig().getFloatDownMax();
        this.maxY = origin.getY() - airHead.getHead().getBoundingBox().expand(airHead.getConfig().getScale()).getHeight() + this.airHead.getConfig().getFloatUpMax();
        double ticks = this.airHead.getConfig().getFloatCycleDurationTicks();
        this.stepHeight = (this.maxY - this.minY) / (ticks / 2.0);
        this.rotationSpeed = this.airHead.getConfig().getRotationPerTick();
        this.initialDelay = initialDelay;
    }

    public void run() {
        if (System.currentTimeMillis() < this.initialDelay) {
            return;
        }
        Location curr = this.airHead.getHead().getLocation().clone();
        if (this.airHead.getConfig().isDoFloat()) {
            if (this.goingUp) {
                curr.add(0.0, this.stepHeight, 0.0);
                if (curr.getY() >= this.maxY) {
                    curr.setY(this.maxY);
                    this.goingUp = false;
                }
            } else {
                curr.subtract(0.0, this.stepHeight, 0.0);
                if (curr.getY() <= this.minY) {
                    curr.setY(this.minY);
                    this.goingUp = true;
                }
            }
        }
        if (this.airHead.getConfig().isDoRotation()) {
            curr.setYaw((float)this.rot);
            this.rot += this.rotationSpeed;
            if (this.rot > 180) {
                this.rot = -180 + (this.rot - 180);
            }
        }
        this.airHead.getHead().teleport(curr);
        if (this.airHead.getHologram() != null) {
            this.airHead.getHologram().teleport(curr.clone().add(0.0, this.airHead.getHead().getBoundingBox().getHeight() + this.airHead.getHologramOffset(), 0.0));
        }
    }
}

