/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.utility;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import lombok.NonNull;
import not.savage.airheads.utility.adapter.LocationConfigAdapter;
import not.savage.airheads.utility.adapter.NamespacedKeyAdapter;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Contract;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigBuilder<T> {
    private Path path;
    private final Class<T> clazz;
    private final YamlConfigurationLoader.Builder builder;
    private final ConfigurationOptions options = ConfigurationOptions.defaults();
    private final TypeSerializerCollection.Builder typeSerializers = TypeSerializerCollection.defaults().childBuilder();

    public ConfigBuilder(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (!clazz.isAnnotationPresent(ConfigSerializable.class)) {
            throw new IllegalArgumentException("Class must be annotated with @ConfigSerializable");
        }
        this.clazz = clazz;
        this.builder = YamlConfigurationLoader.builder().indent(2).nodeStyle(NodeStyle.BLOCK);
        this.typeSerializers.register(Location.class, (TypeSerializer)new LocationConfigAdapter()).register(NamespacedKey.class, (TypeSerializer)new NamespacedKeyAdapter());
    }

    @Contract(value="_->this")
    public ConfigBuilder<T> withPath(Path path) {
        this.path = path;
        ((YamlConfigurationLoader.Builder)this.builder.source(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).sink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));
        return this;
    }

    @Contract(value="_->this")
    public ConfigBuilder<T> forFile(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        this.withPath(f.toPath());
        return this;
    }

    @Contract(value="_,_->this")
    public <Y> ConfigBuilder<T> addAdaptor(Class<Y> clazz, TypeSerializer<Y> serializer) {
        this.typeSerializers.register(clazz, serializer);
        return this;
    }

    public void save(T config) {
        try {
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)this.builder.defaultOptions(this.options.serializers(this.typeSerializers.build()))).build();
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            node.set(this.clazz, config);
            loader.save((ConfigurationNode)node);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Contract(value="->!null")
    public T build() {
        ConfigurationOptions finalOptions = this.options.serializers(this.typeSerializers.build());
        this.builder.defaultOptions(finalOptions);
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createFile(this.path, new FileAttribute[0]);
                try {
                    Object instance = this.clazz.getDeclaredConstructors()[0].newInstance(new Object[0]);
                    YamlConfigurationLoader loader = this.builder.build();
                    CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
                    node.set(this.clazz, instance);
                    loader.save((ConfigurationNode)node);
                    return (T)instance;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            YamlConfigurationLoader loader = this.builder.build();
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            Object t = node.get(this.clazz);
            loader.save((ConfigurationNode)node);
            return (T)t;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Generated
    public Path getPath() {
        return this.path;
    }

    @Generated
    public void setPath(Path path) {
        this.path = path;
    }
}

