/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.config;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import not.savage.airheads.hologram.HologramConfig;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class AirHeadConfig {
    private Location location;
    private HologramConfig hologramTextDisplaySettings = HologramConfig.builder().build();
    private AppearanceSettings appearanceSettings = new AppearanceSettings();
    private InteractSettings interactSettings = new InteractSettings();
    private AnimationSettings animationSettings = new AnimationSettings();

    public AirHeadConfig(Location location) {
        this.location = location;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public HologramConfig getHologramTextDisplaySettings() {
        return this.hologramTextDisplaySettings;
    }

    @Generated
    public AppearanceSettings getAppearanceSettings() {
        return this.appearanceSettings;
    }

    @Generated
    public InteractSettings getInteractSettings() {
        return this.interactSettings;
    }

    @Generated
    public AnimationSettings getAnimationSettings() {
        return this.animationSettings;
    }

    @Generated
    public void setLocation(Location location) {
        this.location = location;
    }

    @Generated
    public void setHologramTextDisplaySettings(HologramConfig hologramTextDisplaySettings) {
        this.hologramTextDisplaySettings = hologramTextDisplaySettings;
    }

    @Generated
    public void setAppearanceSettings(AppearanceSettings appearanceSettings) {
        this.appearanceSettings = appearanceSettings;
    }

    @Generated
    public void setInteractSettings(InteractSettings interactSettings) {
        this.interactSettings = interactSettings;
    }

    @Generated
    public void setAnimationSettings(AnimationSettings animationSettings) {
        this.animationSettings = animationSettings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AirHeadConfig)) {
            return false;
        }
        AirHeadConfig other = (AirHeadConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        HologramConfig this$hologramTextDisplaySettings = this.getHologramTextDisplaySettings();
        HologramConfig other$hologramTextDisplaySettings = other.getHologramTextDisplaySettings();
        if (this$hologramTextDisplaySettings == null ? other$hologramTextDisplaySettings != null : !((Object)this$hologramTextDisplaySettings).equals(other$hologramTextDisplaySettings)) {
            return false;
        }
        AppearanceSettings this$appearanceSettings = this.getAppearanceSettings();
        AppearanceSettings other$appearanceSettings = other.getAppearanceSettings();
        if (this$appearanceSettings == null ? other$appearanceSettings != null : !((Object)this$appearanceSettings).equals(other$appearanceSettings)) {
            return false;
        }
        InteractSettings this$interactSettings = this.getInteractSettings();
        InteractSettings other$interactSettings = other.getInteractSettings();
        if (this$interactSettings == null ? other$interactSettings != null : !((Object)this$interactSettings).equals(other$interactSettings)) {
            return false;
        }
        AnimationSettings this$animationSettings = this.getAnimationSettings();
        AnimationSettings other$animationSettings = other.getAnimationSettings();
        return !(this$animationSettings == null ? other$animationSettings != null : !((Object)this$animationSettings).equals(other$animationSettings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AirHeadConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        HologramConfig $hologramTextDisplaySettings = this.getHologramTextDisplaySettings();
        result = result * 59 + ($hologramTextDisplaySettings == null ? 43 : ((Object)$hologramTextDisplaySettings).hashCode());
        AppearanceSettings $appearanceSettings = this.getAppearanceSettings();
        result = result * 59 + ($appearanceSettings == null ? 43 : ((Object)$appearanceSettings).hashCode());
        InteractSettings $interactSettings = this.getInteractSettings();
        result = result * 59 + ($interactSettings == null ? 43 : ((Object)$interactSettings).hashCode());
        AnimationSettings $animationSettings = this.getAnimationSettings();
        result = result * 59 + ($animationSettings == null ? 43 : ((Object)$animationSettings).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AirHeadConfig(location=" + String.valueOf(this.getLocation()) + ", hologramTextDisplaySettings=" + String.valueOf(this.getHologramTextDisplaySettings()) + ", appearanceSettings=" + String.valueOf(this.getAppearanceSettings()) + ", interactSettings=" + String.valueOf(this.getInteractSettings()) + ", animationSettings=" + String.valueOf(this.getAnimationSettings()) + ")";
    }

    @Generated
    public AirHeadConfig() {
    }

    @ConfigSerializable
    public static class AppearanceSettings {
        @Comment(value="The head texture, in base64 format. You can use https://minecraft-heads.com/ to get a texture.")
        private String headTexture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTY5ZTRhNDNkODJmNWZlMWUxOTM4N2IzOGJmYzE3MDFhMTZiNzA0ZjA5Njg5OWU1MGRiY2JkNGUwNjkxNjg5YSJ9fX0=";
        @Comment(value="Change the scale of the airhead entity. Larger Number = Bigger")
        private double scale = 1.0;
        @Comment(value="The material to overlay the head with, like glass or ice. AIR = No Overlay")
        private Material overlayMaterial = Material.LIGHT_BLUE_STAINED_GLASS;
        @Comment(value="The scale offset of the overlay material. Larger number = larger overlay")
        private double overlayOffset = 0.45;

        @Generated
        public AppearanceSettings() {
        }

        @Generated
        public String getHeadTexture() {
            return this.headTexture;
        }

        @Generated
        public double getScale() {
            return this.scale;
        }

        @Generated
        public Material getOverlayMaterial() {
            return this.overlayMaterial;
        }

        @Generated
        public double getOverlayOffset() {
            return this.overlayOffset;
        }

        @Generated
        public void setHeadTexture(String headTexture) {
            this.headTexture = headTexture;
        }

        @Generated
        public void setScale(double scale) {
            this.scale = scale;
        }

        @Generated
        public void setOverlayMaterial(Material overlayMaterial) {
            this.overlayMaterial = overlayMaterial;
        }

        @Generated
        public void setOverlayOffset(double overlayOffset) {
            this.overlayOffset = overlayOffset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppearanceSettings)) {
                return false;
            }
            AppearanceSettings other = (AppearanceSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getScale(), other.getScale()) != 0) {
                return false;
            }
            if (Double.compare(this.getOverlayOffset(), other.getOverlayOffset()) != 0) {
                return false;
            }
            String this$headTexture = this.getHeadTexture();
            String other$headTexture = other.getHeadTexture();
            if (this$headTexture == null ? other$headTexture != null : !this$headTexture.equals(other$headTexture)) {
                return false;
            }
            Material this$overlayMaterial = this.getOverlayMaterial();
            Material other$overlayMaterial = other.getOverlayMaterial();
            return !(this$overlayMaterial == null ? other$overlayMaterial != null : !this$overlayMaterial.equals(other$overlayMaterial));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppearanceSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $scale = Double.doubleToLongBits(this.getScale());
            result = result * 59 + (int)($scale >>> 32 ^ $scale);
            long $overlayOffset = Double.doubleToLongBits(this.getOverlayOffset());
            result = result * 59 + (int)($overlayOffset >>> 32 ^ $overlayOffset);
            String $headTexture = this.getHeadTexture();
            result = result * 59 + ($headTexture == null ? 43 : $headTexture.hashCode());
            Material $overlayMaterial = this.getOverlayMaterial();
            result = result * 59 + ($overlayMaterial == null ? 43 : $overlayMaterial.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AirHeadConfig.AppearanceSettings(headTexture=" + this.getHeadTexture() + ", scale=" + this.getScale() + ", overlayMaterial=" + String.valueOf(this.getOverlayMaterial()) + ", overlayOffset=" + this.getOverlayOffset() + ")";
        }
    }

    @ConfigSerializable
    public static class InteractSettings {
        @Comment(value="Commands to execute when head is interacted with. Executed as the integrating player.")
        private List<String> interactCommands = List.of("discord");
        @Comment(value="Commands which are only executed if the interaction is a left click.")
        private List<String> leftClickCommands = new ArrayList<String>();
        @Comment(value="Commands which are only executed if the interaction is a right click.")
        private List<String> rightClickCommands = new ArrayList<String>();
        @Comment(value="Commands to execute when head is interacted with. Executed as console sender.")
        private List<String> consoleCommands = new ArrayList<String>();
        @Comment(value="Commands which are only executed if the interaction is a left click. Executed as console sender.")
        private List<String> leftClickConsoleCommands = new ArrayList<String>();
        @Comment(value="Commands which are only executed if the interaction is a right click. Executed as console sender.")
        private List<String> rightClickConsoleCommands = new ArrayList<String>();
        @Comment(value="Message to send when interacted with. Supports mini-message.")
        private List<String> interactMessage = new ArrayList<String>();
        @Comment(value="Sound to be played when interacting")
        private SoundSettings soundSettings = new SoundSettings();
        @Comment(value="Send to a bungee server within the network on interact")
        private String sendTo = "";

        @Generated
        public InteractSettings() {
        }

        @Generated
        public List<String> getInteractCommands() {
            return this.interactCommands;
        }

        @Generated
        public List<String> getLeftClickCommands() {
            return this.leftClickCommands;
        }

        @Generated
        public List<String> getRightClickCommands() {
            return this.rightClickCommands;
        }

        @Generated
        public List<String> getConsoleCommands() {
            return this.consoleCommands;
        }

        @Generated
        public List<String> getLeftClickConsoleCommands() {
            return this.leftClickConsoleCommands;
        }

        @Generated
        public List<String> getRightClickConsoleCommands() {
            return this.rightClickConsoleCommands;
        }

        @Generated
        public List<String> getInteractMessage() {
            return this.interactMessage;
        }

        @Generated
        public void setInteractCommands(List<String> interactCommands) {
            this.interactCommands = interactCommands;
        }

        @Generated
        public void setLeftClickCommands(List<String> leftClickCommands) {
            this.leftClickCommands = leftClickCommands;
        }

        @Generated
        public void setRightClickCommands(List<String> rightClickCommands) {
            this.rightClickCommands = rightClickCommands;
        }

        @Generated
        public void setConsoleCommands(List<String> consoleCommands) {
            this.consoleCommands = consoleCommands;
        }

        @Generated
        public void setLeftClickConsoleCommands(List<String> leftClickConsoleCommands) {
            this.leftClickConsoleCommands = leftClickConsoleCommands;
        }

        @Generated
        public void setRightClickConsoleCommands(List<String> rightClickConsoleCommands) {
            this.rightClickConsoleCommands = rightClickConsoleCommands;
        }

        @Generated
        public void setInteractMessage(List<String> interactMessage) {
            this.interactMessage = interactMessage;
        }

        @Generated
        public void setSoundSettings(SoundSettings soundSettings) {
            this.soundSettings = soundSettings;
        }

        @Generated
        public void setSendTo(String sendTo) {
            this.sendTo = sendTo;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InteractSettings)) {
                return false;
            }
            InteractSettings other = (InteractSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$interactCommands = this.getInteractCommands();
            List<String> other$interactCommands = other.getInteractCommands();
            if (this$interactCommands == null ? other$interactCommands != null : !((Object)this$interactCommands).equals(other$interactCommands)) {
                return false;
            }
            List<String> this$leftClickCommands = this.getLeftClickCommands();
            List<String> other$leftClickCommands = other.getLeftClickCommands();
            if (this$leftClickCommands == null ? other$leftClickCommands != null : !((Object)this$leftClickCommands).equals(other$leftClickCommands)) {
                return false;
            }
            List<String> this$rightClickCommands = this.getRightClickCommands();
            List<String> other$rightClickCommands = other.getRightClickCommands();
            if (this$rightClickCommands == null ? other$rightClickCommands != null : !((Object)this$rightClickCommands).equals(other$rightClickCommands)) {
                return false;
            }
            List<String> this$consoleCommands = this.getConsoleCommands();
            List<String> other$consoleCommands = other.getConsoleCommands();
            if (this$consoleCommands == null ? other$consoleCommands != null : !((Object)this$consoleCommands).equals(other$consoleCommands)) {
                return false;
            }
            List<String> this$leftClickConsoleCommands = this.getLeftClickConsoleCommands();
            List<String> other$leftClickConsoleCommands = other.getLeftClickConsoleCommands();
            if (this$leftClickConsoleCommands == null ? other$leftClickConsoleCommands != null : !((Object)this$leftClickConsoleCommands).equals(other$leftClickConsoleCommands)) {
                return false;
            }
            List<String> this$rightClickConsoleCommands = this.getRightClickConsoleCommands();
            List<String> other$rightClickConsoleCommands = other.getRightClickConsoleCommands();
            if (this$rightClickConsoleCommands == null ? other$rightClickConsoleCommands != null : !((Object)this$rightClickConsoleCommands).equals(other$rightClickConsoleCommands)) {
                return false;
            }
            List<String> this$interactMessage = this.getInteractMessage();
            List<String> other$interactMessage = other.getInteractMessage();
            if (this$interactMessage == null ? other$interactMessage != null : !((Object)this$interactMessage).equals(other$interactMessage)) {
                return false;
            }
            SoundSettings this$soundSettings = this.getSoundSettings();
            SoundSettings other$soundSettings = other.getSoundSettings();
            if (this$soundSettings == null ? other$soundSettings != null : !((Object)this$soundSettings).equals(other$soundSettings)) {
                return false;
            }
            String this$sendTo = this.getSendTo();
            String other$sendTo = other.getSendTo();
            return !(this$sendTo == null ? other$sendTo != null : !this$sendTo.equals(other$sendTo));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InteractSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $interactCommands = this.getInteractCommands();
            result = result * 59 + ($interactCommands == null ? 43 : ((Object)$interactCommands).hashCode());
            List<String> $leftClickCommands = this.getLeftClickCommands();
            result = result * 59 + ($leftClickCommands == null ? 43 : ((Object)$leftClickCommands).hashCode());
            List<String> $rightClickCommands = this.getRightClickCommands();
            result = result * 59 + ($rightClickCommands == null ? 43 : ((Object)$rightClickCommands).hashCode());
            List<String> $consoleCommands = this.getConsoleCommands();
            result = result * 59 + ($consoleCommands == null ? 43 : ((Object)$consoleCommands).hashCode());
            List<String> $leftClickConsoleCommands = this.getLeftClickConsoleCommands();
            result = result * 59 + ($leftClickConsoleCommands == null ? 43 : ((Object)$leftClickConsoleCommands).hashCode());
            List<String> $rightClickConsoleCommands = this.getRightClickConsoleCommands();
            result = result * 59 + ($rightClickConsoleCommands == null ? 43 : ((Object)$rightClickConsoleCommands).hashCode());
            List<String> $interactMessage = this.getInteractMessage();
            result = result * 59 + ($interactMessage == null ? 43 : ((Object)$interactMessage).hashCode());
            SoundSettings $soundSettings = this.getSoundSettings();
            result = result * 59 + ($soundSettings == null ? 43 : ((Object)$soundSettings).hashCode());
            String $sendTo = this.getSendTo();
            result = result * 59 + ($sendTo == null ? 43 : $sendTo.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AirHeadConfig.InteractSettings(interactCommands=" + String.valueOf(this.getInteractCommands()) + ", leftClickCommands=" + String.valueOf(this.getLeftClickCommands()) + ", rightClickCommands=" + String.valueOf(this.getRightClickCommands()) + ", consoleCommands=" + String.valueOf(this.getConsoleCommands()) + ", leftClickConsoleCommands=" + String.valueOf(this.getLeftClickConsoleCommands()) + ", rightClickConsoleCommands=" + String.valueOf(this.getRightClickConsoleCommands()) + ", interactMessage=" + String.valueOf(this.getInteractMessage()) + ", soundSettings=" + String.valueOf(this.getSoundSettings()) + ", sendTo=" + this.getSendTo() + ")";
        }

        @Generated
        public SoundSettings getSoundSettings() {
            return this.soundSettings;
        }

        @Generated
        public String getSendTo() {
            return this.sendTo;
        }

        @ConfigSerializable
        public static class SoundSettings {
            private float volume = 1.0f;
            private float pitch = 1.0f;
            private NamespacedKey sound = NamespacedKey.minecraft((String)"entity.player.levelup");
            private boolean enabled = true;
            private transient Sound cachedSound = null;

            public Sound sound() {
                if (this.cachedSound == null && this.sound != null) {
                    try {
                        this.cachedSound = (Sound)RegistryAccess.registryAccess().getRegistry(RegistryKey.SOUND_EVENT).get(this.sound);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return this.cachedSound;
            }

            @Generated
            public SoundSettings() {
            }

            @Generated
            public float getVolume() {
                return this.volume;
            }

            @Generated
            public float getPitch() {
                return this.pitch;
            }

            @Generated
            public NamespacedKey getSound() {
                return this.sound;
            }

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public Sound getCachedSound() {
                return this.cachedSound;
            }

            @Generated
            public void setVolume(float volume) {
                this.volume = volume;
            }

            @Generated
            public void setPitch(float pitch) {
                this.pitch = pitch;
            }

            @Generated
            public void setSound(NamespacedKey sound) {
                this.sound = sound;
            }

            @Generated
            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setCachedSound(Sound cachedSound) {
                this.cachedSound = cachedSound;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SoundSettings)) {
                    return false;
                }
                SoundSettings other = (SoundSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
                    return false;
                }
                if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
                    return false;
                }
                if (this.isEnabled() != other.isEnabled()) {
                    return false;
                }
                NamespacedKey this$sound = this.getSound();
                NamespacedKey other$sound = other.getSound();
                return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SoundSettings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Float.floatToIntBits(this.getVolume());
                result = result * 59 + Float.floatToIntBits(this.getPitch());
                result = result * 59 + (this.isEnabled() ? 79 : 97);
                NamespacedKey $sound = this.getSound();
                result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "AirHeadConfig.InteractSettings.SoundSettings(volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ", sound=" + String.valueOf(this.getSound()) + ", enabled=" + this.isEnabled() + ", cachedSound=" + String.valueOf(this.getCachedSound()) + ")";
            }
        }
    }

    @ConfigSerializable
    public static class AnimationSettings {
        @Comment(value="Should the head do a floating animation going up and down?")
        private boolean doFloat = true;
        @Comment(value="How high the head floats up, Larger Number = Higher")
        private double floatUpMax = 0.5;
        @Comment(value="How high the head floats down, Larger Number = Higher")
        private double floatDownMax = 0.5;
        @Comment(value="How fast the head floats up & down, Larger Number = Slower")
        private long floatCycleDurationTicks = 80L;
        @Comment(value="Should the head rotate?")
        private boolean doRotation = true;
        @Comment(value="How fast the head rotates, Smaller Number = Slower")
        private int rotationPerTick = 5;

        @Generated
        public AnimationSettings() {
        }

        @Generated
        public boolean isDoFloat() {
            return this.doFloat;
        }

        @Generated
        public double getFloatUpMax() {
            return this.floatUpMax;
        }

        @Generated
        public double getFloatDownMax() {
            return this.floatDownMax;
        }

        @Generated
        public long getFloatCycleDurationTicks() {
            return this.floatCycleDurationTicks;
        }

        @Generated
        public boolean isDoRotation() {
            return this.doRotation;
        }

        @Generated
        public int getRotationPerTick() {
            return this.rotationPerTick;
        }

        @Generated
        public void setDoFloat(boolean doFloat) {
            this.doFloat = doFloat;
        }

        @Generated
        public void setFloatUpMax(double floatUpMax) {
            this.floatUpMax = floatUpMax;
        }

        @Generated
        public void setFloatDownMax(double floatDownMax) {
            this.floatDownMax = floatDownMax;
        }

        @Generated
        public void setFloatCycleDurationTicks(long floatCycleDurationTicks) {
            this.floatCycleDurationTicks = floatCycleDurationTicks;
        }

        @Generated
        public void setDoRotation(boolean doRotation) {
            this.doRotation = doRotation;
        }

        @Generated
        public void setRotationPerTick(int rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnimationSettings)) {
                return false;
            }
            AnimationSettings other = (AnimationSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDoFloat() != other.isDoFloat()) {
                return false;
            }
            if (Double.compare(this.getFloatUpMax(), other.getFloatUpMax()) != 0) {
                return false;
            }
            if (Double.compare(this.getFloatDownMax(), other.getFloatDownMax()) != 0) {
                return false;
            }
            if (this.getFloatCycleDurationTicks() != other.getFloatCycleDurationTicks()) {
                return false;
            }
            if (this.isDoRotation() != other.isDoRotation()) {
                return false;
            }
            return this.getRotationPerTick() == other.getRotationPerTick();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AnimationSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDoFloat() ? 79 : 97);
            long $floatUpMax = Double.doubleToLongBits(this.getFloatUpMax());
            result = result * 59 + (int)($floatUpMax >>> 32 ^ $floatUpMax);
            long $floatDownMax = Double.doubleToLongBits(this.getFloatDownMax());
            result = result * 59 + (int)($floatDownMax >>> 32 ^ $floatDownMax);
            long $floatCycleDurationTicks = this.getFloatCycleDurationTicks();
            result = result * 59 + (int)($floatCycleDurationTicks >>> 32 ^ $floatCycleDurationTicks);
            result = result * 59 + (this.isDoRotation() ? 79 : 97);
            result = result * 59 + this.getRotationPerTick();
            return result;
        }

        @Generated
        public String toString() {
            return "AirHeadConfig.AnimationSettings(doFloat=" + this.isDoFloat() + ", floatUpMax=" + this.getFloatUpMax() + ", floatDownMax=" + this.getFloatDownMax() + ", floatCycleDurationTicks=" + this.getFloatCycleDurationTicks() + ", doRotation=" + this.isDoRotation() + ", rotationPerTick=" + this.getRotationPerTick() + ")";
        }
    }
}

