/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.hologram;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import not.savage.airheads.hologram.BillboardConstraints;
import not.savage.airheads.hologram.HologramConfig;
import not.savage.airheads.hologram.TextAlignment;
import not.savage.airheads.shade.com.github.retrooper.packetevents.PacketEvents;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.Quaternion4f;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.Vector3f;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import not.savage.airheads.shade.io.github.retrooper.packetevents.util.SpigotConversionUtil;
import not.savage.airheads.tasks.HologramUpdateTask;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TextDisplayHologram {
    private final int entityId;
    private final UUID uuid;
    private final JavaPlugin plugin;
    private final HologramConfig config;
    private final World world;
    private final int interpolationDelay;
    private final int transformationInterpolationDelay;
    private final int positionInterpolationDelay;
    private final Vector3f transformation;
    private final Vector3f scale;
    private final Quaternion4f rotationLeft = new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f);
    private final Quaternion4f rotationRight = new Quaternion4f(0.0f, 0.0f, 0.0f, 1.0f);
    private final int brightnessOverride = -1;
    private final int glowOverride = -1;
    private final int lineWidth = 200;
    private byte billboardConstraints = 0;
    private final float viewRange;
    private final float shadowRadius;
    private final float shadowStrength;
    private final float width;
    private final float height;
    private final float pitch;
    private final float yaw;
    private final List<String> text = new ArrayList<String>();
    private int backgroundColor = 0x4000000;
    private final byte textOpacity = (byte)-1;
    private byte meta = 0;
    private final double offset;
    private final HologramUpdateTask hologramUpdateTask;
    private transient Location currentLocation;

    public TextDisplayHologram(JavaPlugin plugin, HologramConfig config, int entityId, UUID uuid, World world) {
        this.entityId = entityId;
        this.uuid = uuid;
        this.config = config;
        this.plugin = plugin;
        this.world = world;
        this.interpolationDelay = config.getUpdateIntervalTicks() == -1 ? 0 : config.getUpdateIntervalTicks();
        this.positionInterpolationDelay = config.getUpdateIntervalTicks() == -1 ? 0 : config.getUpdateIntervalTicks();
        this.transformationInterpolationDelay = config.getUpdateIntervalTicks() == -1 ? 0 : config.getUpdateIntervalTicks();
        this.transformation = new Vector3f(config.getTranslationX(), config.getTranslationY(), config.getTranslationZ());
        this.scale = new Vector3f(config.getScaleX(), config.getScaleY(), config.getScaleZ());
        BillboardConstraints.fromString(config.getBillboardConstraints()).ifPresentOrElse(constraints -> {
            this.billboardConstraints = constraints.getId();
        }, () -> {
            plugin.getLogger().warning("Unknown billboard constraint: " + config.getBillboardConstraints() + ", must be one of: " + Arrays.toString((Object[])BillboardConstraints.values()));
            this.billboardConstraints = BillboardConstraints.FIXED.getId();
        });
        this.text.addAll(config.getHologramText());
        TextAlignment.fromString(config.getTextAlignment()).ifPresentOrElse(alignment -> alignment.align(this), () -> {
            plugin.getLogger().warning("Unknown text alignment: " + config.getTextAlignment() + ", must be one of: " + Arrays.toString((Object[])TextAlignment.values()));
            TextAlignment.CENTERED.align(this);
        });
        this.shadowRadius = config.getShadowRadius();
        this.shadowStrength = config.getShadowStrength();
        this.viewRange = config.getRenderDistance();
        this.width = config.getWidth();
        this.height = config.getHeight();
        this.pitch = config.getPitch();
        this.yaw = config.getYaw();
        this.setHasShadow(config.isHasTextShadow());
        this.setIsSeeThrough(config.isTransparentBackground());
        String hex = config.getBackgroundColor();
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        this.backgroundColor = (int)Long.parseLong(hex, 16);
        this.setUseDefaultBackground(this.backgroundColor < 0 || this.backgroundColor == 0x40000000);
        this.offset = config.getHologramOffset();
        if (config.getUpdateIntervalTicks() != -1) {
            this.hologramUpdateTask = new HologramUpdateTask(this, config.getUpdateIntervalTicks());
            this.hologramUpdateTask.register();
        } else {
            this.hologramUpdateTask = null;
        }
    }

    public WrapperPlayServerEntityMetadata toPacket(Player player) {
        return new WrapperPlayServerEntityMetadata(this.entityId, this.packEntityData(player));
    }

    private List<EntityData<?>> packEntityData(Player player) {
        ArrayList data = new ArrayList();
        data.add(new EntityData<Integer>(8, EntityDataTypes.INT, this.interpolationDelay));
        data.add(new EntityData<Integer>(9, EntityDataTypes.INT, this.transformationInterpolationDelay));
        data.add(new EntityData<Integer>(10, EntityDataTypes.INT, this.positionInterpolationDelay));
        data.add(new EntityData<Vector3f>(11, EntityDataTypes.VECTOR3F, this.transformation));
        data.add(new EntityData<Vector3f>(12, EntityDataTypes.VECTOR3F, this.scale));
        data.add(new EntityData<Quaternion4f>(13, EntityDataTypes.QUATERNION, this.rotationLeft));
        data.add(new EntityData<Quaternion4f>(14, EntityDataTypes.QUATERNION, this.rotationRight));
        data.add(new EntityData<Byte>(15, EntityDataTypes.BYTE, this.billboardConstraints));
        data.add(new EntityData<Integer>(16, EntityDataTypes.INT, -1));
        data.add(new EntityData<Float>(17, EntityDataTypes.FLOAT, Float.valueOf(this.viewRange)));
        data.add(new EntityData<Float>(18, EntityDataTypes.FLOAT, Float.valueOf(this.shadowRadius)));
        data.add(new EntityData<Float>(19, EntityDataTypes.FLOAT, Float.valueOf(this.shadowStrength)));
        data.add(new EntityData<Float>(20, EntityDataTypes.FLOAT, Float.valueOf(this.width)));
        data.add(new EntityData<Float>(21, EntityDataTypes.FLOAT, Float.valueOf(this.height)));
        data.add(new EntityData<Integer>(22, EntityDataTypes.INT, -1));
        ArrayList playerView = new ArrayList(PlaceholderAPI.setPlaceholders((Player)player, this.text));
        data.add(new EntityData<Component>(23, EntityDataTypes.ADV_COMPONENT, MiniMessage.miniMessage().deserialize((Object)String.join((CharSequence)"\n", playerView))));
        data.add(new EntityData<Integer>(24, EntityDataTypes.INT, 200));
        data.add(new EntityData<Integer>(25, EntityDataTypes.INT, this.backgroundColor));
        data.add(new EntityData<Byte>(26, EntityDataTypes.BYTE, (byte)-1));
        data.add(new EntityData<Byte>(27, EntityDataTypes.BYTE, this.meta));
        return data;
    }

    public void spawn(Player player, Location location) {
        location.add(0.0, this.getOffset(), 0.0);
        location.setPitch(this.pitch);
        location.setYaw(this.pitch);
        this.currentLocation = location;
        CompletableFuture.runAsync(() -> {
            WrapperPlayServerSpawnEntity addDisplayEntityPacket = new WrapperPlayServerSpawnEntity(this.getEntityId(), this.getUuid(), SpigotConversionUtil.fromBukkitEntityType(EntityType.TEXT_DISPLAY), SpigotConversionUtil.fromBukkitLocation(location), 0.0f, 0, null);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, addDisplayEntityPacket);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, this.toPacket(player));
        }).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to spawn hologram for player " + player.getName() + " at " + String.valueOf(location) + ": " + ex.getMessage());
            return null;
        });
    }

    public void update(Player player) {
        CompletableFuture.runAsync(() -> PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, this.toPacket(player))).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to update hologram for player " + player.getName() + ": " + ex.getMessage());
            return null;
        });
    }

    public void teleport(Location location) {
        if (!location.getWorld().getName().equals(this.getWorld().getName())) {
            throw new IllegalStateException("Cannot teleport to a different world!");
        }
        location.add(0.0, this.getOffset(), 0.0);
        location.setPitch(this.pitch);
        location.setYaw(this.yaw);
        this.currentLocation = location;
        CompletableFuture.runAsync(() -> {
            WrapperPlayServerEntityTeleport teleportPacket = new WrapperPlayServerEntityTeleport(this.getEntityId(), SpigotConversionUtil.fromBukkitLocation(location), false);
            location.getWorld().getPlayers().forEach(player -> PacketEvents.getAPI().getPlayerManager().sendPacket(player, teleportPacket));
        }).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to teleport hologram to " + String.valueOf(location) + ": " + ex.getMessage());
            return null;
        });
    }

    public void setHasShadow(boolean hasShadow) {
        this.meta = hasShadow ? (byte)(this.meta | 1) : (byte)(this.meta & 0xFFFFFFFE);
    }

    public void setIsSeeThrough(boolean isSeeThrough) {
        this.meta = isSeeThrough ? (byte)(this.meta | 2) : (byte)(this.meta & 0xFFFFFFFD);
    }

    public void setUseDefaultBackground(boolean useDefaultBackground) {
        this.meta = useDefaultBackground ? (byte)(this.meta | 4) : (byte)(this.meta & 0xFFFFFFFB);
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public HologramConfig getConfig() {
        return this.config;
    }

    @Generated
    public World getWorld() {
        return this.world;
    }

    @Generated
    public int getInterpolationDelay() {
        return this.interpolationDelay;
    }

    @Generated
    public int getTransformationInterpolationDelay() {
        return this.transformationInterpolationDelay;
    }

    @Generated
    public int getPositionInterpolationDelay() {
        return this.positionInterpolationDelay;
    }

    @Generated
    public Vector3f getTransformation() {
        return this.transformation;
    }

    @Generated
    public Vector3f getScale() {
        return this.scale;
    }

    @Generated
    public Quaternion4f getRotationLeft() {
        return this.rotationLeft;
    }

    @Generated
    public Quaternion4f getRotationRight() {
        return this.rotationRight;
    }

    @Generated
    public int getBrightnessOverride() {
        Objects.requireNonNull(this);
        return -1;
    }

    @Generated
    public int getGlowOverride() {
        Objects.requireNonNull(this);
        return -1;
    }

    @Generated
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Generated
    public byte getBillboardConstraints() {
        return this.billboardConstraints;
    }

    @Generated
    public float getViewRange() {
        return this.viewRange;
    }

    @Generated
    public float getShadowRadius() {
        return this.shadowRadius;
    }

    @Generated
    public float getShadowStrength() {
        return this.shadowStrength;
    }

    @Generated
    public float getWidth() {
        return this.width;
    }

    @Generated
    public float getHeight() {
        return this.height;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public List<String> getText() {
        return this.text;
    }

    @Generated
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public byte getTextOpacity() {
        Objects.requireNonNull(this);
        return -1;
    }

    @Generated
    public byte getMeta() {
        return this.meta;
    }

    @Generated
    public double getOffset() {
        return this.offset;
    }

    @Generated
    public HologramUpdateTask getHologramUpdateTask() {
        return this.hologramUpdateTask;
    }

    @Generated
    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    @Generated
    public void setMeta(byte meta) {
        this.meta = meta;
    }
}

