/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.frog;

import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.frog.FrogVariants;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.frog.StaticFrogVariant;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBT;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import not.savage.airheads.shade.com.github.retrooper.packetevents.resources.ResourceLocation;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface FrogVariant
extends MappedEntity,
CopyableEntity<FrogVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static FrogVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(FrogVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, FrogVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static FrogVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticFrogVariant(data, assetId);
    }

    public static NBT encode(FrogVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

