/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.world.painting;

import not.savage.airheads.shade.com.github.retrooper.packetevents.manager.server.ServerVersion;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBT;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.world.painting.PaintingVariants;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.world.painting.StaticPaintingVariant;
import not.savage.airheads.shade.com.github.retrooper.packetevents.resources.ResourceLocation;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface PaintingVariant
extends MappedEntity,
CopyableEntity<PaintingVariant>,
DeepComparableEntity {
    public int getWidth();

    public int getHeight();

    public ResourceLocation getAssetId();

    public static PaintingVariant read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21)) {
            return wrapper.readMappedEntityOrDirect(PaintingVariants.getRegistry(), PaintingVariant::readDirect);
        }
        return wrapper.readMappedEntity(PaintingVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, PaintingVariant variant) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21)) {
            wrapper.writeMappedEntityOrDirect(variant, PaintingVariant::writeDirect);
        } else {
            wrapper.writeMappedEntity(variant);
        }
    }

    public static PaintingVariant readDirect(PacketWrapper<?> wrapper) {
        int width = wrapper.readVarInt();
        int height = wrapper.readVarInt();
        ResourceLocation assetId = wrapper.readIdentifier();
        return new StaticPaintingVariant(width, height, assetId);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, PaintingVariant variant) {
        wrapper.writeVarInt(variant.getWidth());
        wrapper.writeVarInt(variant.getHeight());
        wrapper.writeIdentifier(variant.getAssetId());
    }

    public static PaintingVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        int width = compound.getNumberTagOrThrow("width").getAsInt();
        int height = compound.getNumberTagOrThrow("height").getAsInt();
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticPaintingVariant(data, width, height, assetId);
    }

    public static NBT encode(PaintingVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("width", new NBTInt(variant.getWidth()));
        compound.setTag("height", new NBTInt(variant.getHeight()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

