/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.tasks;

import not.savage.airheads.hologram.TextDisplayHologram;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HologramUpdateTask
extends BukkitRunnable {
    private final TextDisplayHologram hologram;
    private final int updateInterval;
    private int taskId = -1;

    public HologramUpdateTask(TextDisplayHologram hologram, int updateInterval) {
        this.hologram = hologram;
        this.updateInterval = updateInterval;
    }

    public void run() {
        this.hologram.getWorld().getPlayers().forEach(this.hologram::update);
    }

    public void register() {
        if (this.taskId != -1) {
            return;
        }
        this.taskId = this.runTaskTimerAsynchronously((Plugin)this.hologram.getPlugin(), 0L, this.updateInterval).getTaskId();
    }

    public void cancel() {
        if (this.taskId == -1) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.taskId);
        this.taskId = -1;
    }
}

