/*
 * Decompiled with CFR 0.152.
 */
package not.savage.shade.hologrambridge.connector.impl;

import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMILocation;
import not.savage.shade.hologrambridge.connector.Connector;
import not.savage.shade.hologrambridge.hologram.Hologram;
import not.savage.shade.hologrambridge.hologram.VisibilityManager;
import not.savage.shade.hologrambridge.hologram.impl.OptimalHologram;
import not.savage.shade.hologrambridge.lines.Line;
import not.savage.shade.hologrambridge.lines.types.ItemLine;
import not.savage.shade.hologrambridge.lines.types.TextLine;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public final class CMIImpl
implements Connector {
    @Override
    public Hologram createHologram(Location location) {
        return new OptimalHologram(this, new CMIHologram(UUID.randomUUID().toString(), new CMILocation(location)), location);
    }

    @Override
    public void setLine(Hologram hologram, int lineIndex, Line line) {
        Optional<CMIHologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        CMIHologram cmiHologram = hologramOptional.get();
        if (line instanceof ItemLine) {
            return;
        }
        if (line instanceof TextLine) {
            cmiHologram.setLine(lineIndex, ((TextLine)line).getText());
        }
    }

    @Override
    public void updateLine(Hologram hologram, int lineIndex, Line line) {
        Optional<CMIHologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        CMIHologram cmiHologram = hologramOptional.get();
        if (line instanceof ItemLine) {
            return;
        }
        if (line instanceof TextLine) {
            String text = ((TextLine)line).getText();
            cmiHologram.setLine(lineIndex, text);
        }
    }

    @Override
    public void appendLine(Hologram hologram, Line line) {
        Optional<CMIHologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        CMIHologram cmiHologram = hologramOptional.get();
        if (line instanceof ItemLine) {
            return;
        }
        if (line instanceof TextLine) {
            String text = ((TextLine)line).getText();
            cmiHologram.addLine(text);
        }
    }

    @Override
    public void clearLines(Hologram hologram) {
        Optional<CMIHologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        CMIHologram cmiHologram = hologramOptional.get();
        cmiHologram.setLines(Collections.emptyList());
    }

    @Override
    public void teleport(Hologram hologram, Location location) {
        Optional<CMIHologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        CMIHologram cmiHologram = hologramOptional.get();
        cmiHologram.setLoc(location);
    }

    @Override
    public void delete(Hologram hologram) {
        Optional<CMIHologram> hologramOptional = this.getHologram(hologram);
        hologramOptional.ifPresent(CMIHologram::remove);
    }

    @Override
    public void setVisibleByDefault(VisibilityManager visibilityManager, boolean visibleByDefault) {
        throw new UnsupportedOperationException("CMI does not support per-player holograms!");
    }

    @Override
    public void showTo(VisibilityManager visibilityManager, Player player) {
        throw new UnsupportedOperationException("CMI does not support per-player holograms!");
    }

    @Override
    public void hideTo(VisibilityManager visibilityManager, Player player) {
        Optional<CMIHologram> hologramOptional = this.getHologram(visibilityManager.getHologram());
        if (!hologramOptional.isPresent()) {
            return;
        }
        CMIHologram cmiHologram = hologramOptional.get();
        cmiHologram.hide(player.getUniqueId());
    }

    @Override
    public double getHeight(Hologram hologram) {
        Optional<CMIHologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return 0.0;
        }
        CMIHologram cmiHologram = hologramOptional.get();
        return cmiHologram.getHeight();
    }

    private Optional<CMIHologram> getHologram(Hologram hologram) {
        Object hologramObject = hologram.getHologramAsObject();
        if (hologramObject instanceof CMIHologram) {
            return Optional.of((CMIHologram)hologramObject);
        }
        return Optional.empty();
    }
}

