/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import lombok.Generated;
import not.savage.airheads.AirHeadsPlugin;
import not.savage.airheads.config.AirHeadConfig;
import not.savage.airheads.hologram.TextDisplayHologram;
import not.savage.airheads.shade.com.github.retrooper.packetevents.PacketEvents;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.item.ItemStack;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.player.Equipment;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.player.EquipmentSlot;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import not.savage.airheads.shade.io.github.retrooper.packetevents.util.SpigotConversionUtil;
import not.savage.airheads.shade.io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import not.savage.airheads.tasks.FloatAnimationTask;
import not.savage.airheads.utility.Heads;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class AirHeadEntity {
    public static final float DEFAULT_ARMOR_STAND_HEIGHT = 1.975f;
    private final AirHeadsPlugin plugin;
    private final AirHeadConfig config;
    private final int entityId;
    private final UUID entityUuid;
    private final int glassEntityId;
    private final UUID glassEntityUuid;
    private final TextDisplayHologram textDisplay;
    private final String name;
    private Location currentLocation;
    private final ItemStack headItem;
    private final ItemStack glassItem;
    private final int floatTask;
    private final long activeAfter;

    public AirHeadEntity(AirHeadsPlugin plugin, String name, AirHeadConfig config, long delayedTicks) {
        this.plugin = plugin;
        this.config = config;
        this.currentLocation = config.getLocation().clone().add(0.5, -this.trueHeight(), 0.5);
        this.activeAfter = System.currentTimeMillis() + delayedTicks * 50L;
        this.entityId = SpigotReflectionUtil.generateEntityId();
        this.entityUuid = UUID.randomUUID();
        this.glassEntityId = SpigotReflectionUtil.generateEntityId();
        this.glassEntityUuid = UUID.randomUUID();
        this.name = name;
        this.floatTask = new FloatAnimationTask(this.currentLocation, this, this.activeAfter).runTaskTimerAsynchronously((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), 0L, 1L).getTaskId();
        if (!config.getAppearanceSettings().getHeadTexture().equals("%player%")) {
            org.bukkit.inventory.ItemStack head = new org.bukkit.inventory.ItemStack(Material.PLAYER_HEAD, 1);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            Heads.setBase64ToSkullMeta(config.getAppearanceSettings().getHeadTexture(), meta);
            head.setItemMeta((ItemMeta)meta);
            this.headItem = SpigotConversionUtil.fromBukkitItemStack(head);
        } else {
            this.headItem = null;
        }
        this.glassItem = !config.getAppearanceSettings().getOverlayMaterial().isAir() ? SpigotConversionUtil.fromBukkitItemStack(new org.bukkit.inventory.ItemStack(config.getAppearanceSettings().getOverlayMaterial(), 1)) : null;
        this.textDisplay = new TextDisplayHologram(plugin, config.getHologramTextDisplaySettings(), SpigotReflectionUtil.generateEntityId(), UUID.randomUUID(), this.currentLocation.getWorld());
    }

    public void spawnForPlayer(Player player) {
        CompletableFuture.runAsync(() -> {
            WrapperPlayServerEntityEquipment entityEquipPacket;
            WrapperPlayServerSpawnEntity entitySpawnPacket = new WrapperPlayServerSpawnEntity(this.entityId, this.entityUuid, SpigotConversionUtil.fromBukkitEntityType(EntityType.ARMOR_STAND), SpigotConversionUtil.fromBukkitLocation(this.currentLocation), 0.0f, 0, null);
            if (this.headItem == null) {
                org.bukkit.inventory.ItemStack head = new org.bukkit.inventory.ItemStack(Material.PLAYER_HEAD, 1);
                SkullMeta meta = (SkullMeta)head.getItemMeta();
                Heads.setReflectionSkin(player, meta);
                head.setItemMeta((ItemMeta)meta);
                entityEquipPacket = new WrapperPlayServerEntityEquipment(this.entityId, List.of(new Equipment(EquipmentSlot.HELMET, SpigotConversionUtil.fromBukkitItemStack(head))));
            } else {
                entityEquipPacket = new WrapperPlayServerEntityEquipment(this.entityId, List.of(new Equipment(EquipmentSlot.HELMET, this.headItem)));
            }
            WrapperPlayServerEntityMetadata entityMetaPacket = new WrapperPlayServerEntityMetadata(this.entityId, List.of(new EntityData<Byte>(0, EntityDataTypes.BYTE, (byte)32)));
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, entitySpawnPacket);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, entityEquipPacket);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, entityMetaPacket);
            if (this.glassItem != null) {
                WrapperPlayServerSpawnEntity glassSpawnPacket = new WrapperPlayServerSpawnEntity(this.glassEntityId, this.glassEntityUuid, SpigotConversionUtil.fromBukkitEntityType(EntityType.ARMOR_STAND), SpigotConversionUtil.fromBukkitLocation(this.currentLocation.clone().add(0.0, -this.config.getAppearanceSettings().getOverlayOffset(), 0.0)), 0.0f, 0, null);
                WrapperPlayServerEntityEquipment glassEquipPacket = new WrapperPlayServerEntityEquipment(this.glassEntityId, List.of(new Equipment(EquipmentSlot.HELMET, this.glassItem)));
                WrapperPlayServerEntityMetadata glassMetaPacket = new WrapperPlayServerEntityMetadata(this.glassEntityId, List.of(new EntityData<Byte>(0, EntityDataTypes.BYTE, (byte)32)));
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, glassSpawnPacket);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, glassEquipPacket);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, glassMetaPacket);
            }
            if (this.config.getAppearanceSettings().getScale() != 1.0) {
                WrapperPlayServerUpdateAttributes entityAttributes = this.createScalerPacket(this.entityId, this.config.getAppearanceSettings().getScale());
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, entityAttributes);
                if (this.glassItem != null) {
                    WrapperPlayServerUpdateAttributes glassAttributes = this.createScalerPacket(this.glassEntityId, this.config.getAppearanceSettings().getScale() + 0.3);
                    PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, glassAttributes);
                }
            } else if (this.glassItem != null) {
                WrapperPlayServerUpdateAttributes glassAttributes = this.createScalerPacket(this.glassEntityId, 1.3);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, glassAttributes);
            }
            this.textDisplay.spawn(player, this.currentLocation.clone().add(0.0, this.trueHeight(), 0.0));
        }).exceptionally(throwable -> {
            this.plugin.getLogger().log(Level.WARNING, "Failed to spawn AirHead for player %s".formatted(player.getName()), (Throwable)throwable);
            return null;
        });
    }

    @NotNull
    private WrapperPlayServerUpdateAttributes createScalerPacket(int entity, double scale) {
        WrapperPlayServerUpdateAttributes.Property scalePacket = new WrapperPlayServerUpdateAttributes.Property(Attributes.SCALE, scale, new ArrayList<WrapperPlayServerUpdateAttributes.PropertyModifier>());
        WrapperPlayServerUpdateAttributes.Property interactionRange = new WrapperPlayServerUpdateAttributes.Property(Attributes.ENTITY_INTERACTION_RANGE, scale, new ArrayList<WrapperPlayServerUpdateAttributes.PropertyModifier>());
        return new WrapperPlayServerUpdateAttributes(entity, List.of(scalePacket, interactionRange));
    }

    public void teleport(Location location) {
        CompletableFuture.runAsync(() -> {
            this.textDisplay.teleport(location.clone().add(0.0, this.trueHeight(), 0.0));
            WrapperPlayServerEntityTeleport mainEntityTeleport = new WrapperPlayServerEntityTeleport(this.entityId, SpigotConversionUtil.fromBukkitLocation(location), false);
            WrapperPlayServerEntityTeleport overlayEntityTeleport = this.glassItem == null ? null : new WrapperPlayServerEntityTeleport(this.glassEntityId, SpigotConversionUtil.fromBukkitLocation(location.clone().add(0.0, -this.config.getAppearanceSettings().getOverlayOffset(), 0.0)), false);
            this.getCurrentLocation().getWorld().getPlayers().forEach(player -> {
                if (player.isOnline()) {
                    PacketEvents.getAPI().getPlayerManager().sendPacket(player, mainEntityTeleport);
                    if (overlayEntityTeleport != null) {
                        PacketEvents.getAPI().getPlayerManager().sendPacket(player, overlayEntityTeleport);
                    }
                }
            });
        });
        this.setCurrentLocation(location);
    }

    public void remove() {
        if (this.floatTask != -1) {
            Bukkit.getScheduler().cancelTask(this.floatTask);
        }
        int[] entitiesToRemove = new int[this.glassItem != null ? 3 : 2];
        entitiesToRemove[0] = this.entityId;
        entitiesToRemove[1] = this.textDisplay.getEntityId();
        if (this.glassItem != null) {
            entitiesToRemove[2] = this.glassEntityId;
        }
        if (this.textDisplay.getHologramUpdateTask() != null) {
            this.textDisplay.getHologramUpdateTask().cancel();
        }
        WrapperPlayServerDestroyEntities destroyPacket = new WrapperPlayServerDestroyEntities(entitiesToRemove);
        this.getCurrentLocation().getWorld().getPlayers().forEach(player -> {
            if (player.isOnline()) {
                PacketEvents.getAPI().getPlayerManager().sendPacket(player, destroyPacket);
            }
        });
    }

    public double trueHeight() {
        double configScale = this.config.getAppearanceSettings().getScale();
        if (configScale == 1.0) {
            return 1.975f;
        }
        if (configScale < 1.0) {
            return (double)1.975f * configScale;
        }
        return (double)1.975f + configScale;
    }

    @Generated
    public AirHeadsPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public AirHeadConfig getConfig() {
        return this.config;
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public UUID getEntityUuid() {
        return this.entityUuid;
    }

    @Generated
    public int getGlassEntityId() {
        return this.glassEntityId;
    }

    @Generated
    public UUID getGlassEntityUuid() {
        return this.glassEntityUuid;
    }

    @Generated
    public TextDisplayHologram getTextDisplay() {
        return this.textDisplay;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    @Generated
    public ItemStack getHeadItem() {
        return this.headItem;
    }

    @Generated
    public ItemStack getGlassItem() {
        return this.glassItem;
    }

    @Generated
    public int getFloatTask() {
        return this.floatTask;
    }

    @Generated
    public long getActiveAfter() {
        return this.activeAfter;
    }

    @Generated
    public void setCurrentLocation(Location currentLocation) {
        this.currentLocation = currentLocation;
    }
}

