/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import java.util.HashMap;
import lombok.Generated;
import not.savage.airheads.AirHeadEntity;
import not.savage.airheads.AirHeadsPlugin;
import org.bukkit.entity.Player;

public class PacketEntityCache {
    private final AirHeadsPlugin plugin;
    private final HashMap<Integer, AirHeadEntity> byEntityId = new HashMap();
    private final HashMap<Integer, AirHeadEntity> byGlassOverlayId = new HashMap();

    public PacketEntityCache(AirHeadsPlugin plugin) {
        this.plugin = plugin;
    }

    public void addEntity(int entityId, AirHeadEntity entity) {
        this.byEntityId.put(entityId, entity);
        if (entity.getGlassItem() != null) {
            this.byGlassOverlayId.put(entity.getGlassEntityId(), entity);
        }
    }

    public AirHeadEntity getEntityByEntityId(int entityId) {
        AirHeadEntity entity = this.byEntityId.get(entityId);
        if (entity == null) {
            entity = this.byGlassOverlayId.get(entityId);
        }
        return entity;
    }

    public AirHeadEntity getEntityByName(String name) {
        for (AirHeadEntity entity : this.byEntityId.values()) {
            if (!entity.getName().equalsIgnoreCase(name)) continue;
            return entity;
        }
        return null;
    }

    public AirHeadEntity getByAirHeadName(String name) {
        for (AirHeadEntity entity : this.byEntityId.values()) {
            if (!entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void clear() {
        for (AirHeadEntity entity : this.byEntityId.values()) {
            entity.remove();
        }
        this.byEntityId.clear();
    }

    public void removeEntity(int entityId) {
        AirHeadEntity entity = this.byEntityId.remove(entityId);
        if (entity != null) {
            entity.remove();
        }
    }

    public void removeEntityByName(String name) {
        AirHeadEntity entity = this.getEntityByName(name);
        if (entity != null) {
            entity.remove();
        }
    }

    public void showWorld(Player player) {
        for (AirHeadEntity entity : this.byEntityId.values()) {
            if (!entity.getCurrentLocation().getWorld().getName().equals(player.getWorld().getName())) continue;
            entity.spawnForPlayer(player);
        }
    }

    @Generated
    public AirHeadsPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public HashMap<Integer, AirHeadEntity> getByEntityId() {
        return this.byEntityId;
    }

    @Generated
    public HashMap<Integer, AirHeadEntity> getByGlassOverlayId() {
        return this.byGlassOverlayId;
    }
}

