/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.hologram;

import java.util.Optional;
import not.savage.airheads.hologram.TextDisplayHologram;

public enum TextAlignment {
    CENTERED(0),
    LEFT(1),
    RIGHT(2);

    private final int id;

    private TextAlignment(int id) {
        this.id = id;
    }

    public static Optional<TextAlignment> fromString(String name) {
        for (TextAlignment alignment : TextAlignment.values()) {
            if (!alignment.name().equalsIgnoreCase(name)) continue;
            return Optional.of(alignment);
        }
        return Optional.empty();
    }

    public void align(TextDisplayHologram hologram) {
        byte meta = hologram.getMeta();
        meta = (byte)(meta & 0xFFFFFFE7);
        meta = (byte)(meta | (byte)(this.id << 3));
        hologram.setMeta(meta);
    }
}

