/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.play.server;

import java.util.ArrayList;
import java.util.List;
import not.savage.airheads.shade.com.github.retrooper.packetevents.event.PacketSendEvent;
import not.savage.airheads.shade.com.github.retrooper.packetevents.manager.server.ServerVersion;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.particle.Particle;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.particle.data.ParticleData;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.sound.Sound;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.sound.Sounds;
import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.sound.StaticSound;
import not.savage.airheads.shade.com.github.retrooper.packetevents.resources.ResourceLocation;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.Vector3d;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.Vector3f;
import not.savage.airheads.shade.com.github.retrooper.packetevents.util.Vector3i;
import not.savage.airheads.shade.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerExplosion
extends PacketWrapper<WrapperPlayServerExplosion> {
    private Vector3d position;
    private float strength;
    private List<Vector3i> records;
    @Nullable
    private Vector3d knockback;
    private Particle<?> smallParticle;
    private Particle<?> particle;
    private BlockInteraction blockInteraction;
    private Sound explosionSound;

    public WrapperPlayServerExplosion(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion) {
        this(position, strength, records, playerMotion, new Particle<ParticleData>(ParticleTypes.EXPLOSION), new Particle<ParticleData>(ParticleTypes.EXPLOSION_EMITTER), BlockInteraction.DESTROY_BLOCKS, new ResourceLocation("minecraft:entity.generic.explode"), null);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion, Particle<?> smallExplosionParticles, Particle<?> largeExplosionParticles, BlockInteraction blockInteraction, ResourceLocation explosionSoundKey, @Nullable Float explosionSoundRange) {
        this(position, strength, records, playerMotion, smallExplosionParticles, largeExplosionParticles, blockInteraction, (Sound)new StaticSound(explosionSoundKey, explosionSoundRange));
    }

    @Deprecated
    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion, Particle<?> smallParticle, Particle<?> particle, BlockInteraction blockInteraction, Sound explosionSound) {
        this(position, strength, records, new Vector3d(playerMotion.x, playerMotion.y, playerMotion.z), smallParticle, particle, blockInteraction, explosionSound);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3d playerMotion, Particle<?> smallParticle, Particle<?> particle, BlockInteraction blockInteraction, Sound explosionSound) {
        super(PacketType.Play.Server.EXPLOSION);
        this.position = position;
        this.strength = strength;
        this.records = records;
        this.knockback = playerMotion;
        this.smallParticle = smallParticle;
        this.particle = particle;
        this.blockInteraction = blockInteraction;
        this.explosionSound = explosionSound;
    }

    public WrapperPlayServerExplosion(Vector3d position, @Nullable Vector3d playerMotion) {
        this(position, playerMotion, new Particle<ParticleData>(ParticleTypes.EXPLOSION_EMITTER), Sounds.ENTITY_GENERIC_EXPLODE);
    }

    public WrapperPlayServerExplosion(Vector3d position, @Nullable Vector3d playerMotion, Particle<?> particle, Sound explosionSound) {
        super(PacketType.Play.Server.EXPLOSION);
        this.position = position;
        this.knockback = playerMotion;
        this.particle = particle;
        this.explosionSound = explosionSound;
    }

    @Override
    public void read() {
        this.position = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3) ? Vector3d.read(this) : new Vector3d(this.readFloat(), this.readFloat(), this.readFloat());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            this.knockback = (Vector3d)this.readOptional(Vector3d::read);
            this.particle = Particle.read(this);
            this.explosionSound = Sound.read(this);
        } else {
            this.strength = this.readFloat();
            int recordsLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
            this.records = new ArrayList<Vector3i>(recordsLength);
            Vector3i floor = this.toFloor(this.position);
            for (int i = 0; i < recordsLength; ++i) {
                int chunkPosX = this.readByte() + floor.getX();
                int chunkPosY = this.readByte() + floor.getY();
                int chunkPosZ = this.readByte() + floor.getZ();
                this.records.add(new Vector3i(chunkPosX, chunkPosY, chunkPosZ));
            }
            float motX = this.readFloat();
            float motY = this.readFloat();
            float motZ = this.readFloat();
            this.knockback = new Vector3d(motX, motY, motZ);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
                this.blockInteraction = BlockInteraction.values()[this.readVarInt()];
                this.smallParticle = Particle.read(this);
                this.particle = Particle.read(this);
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                    this.explosionSound = Sound.read(this);
                } else {
                    ResourceLocation explosionSoundKey = this.readIdentifier();
                    Float explosionSoundRange = (Float)this.readOptional(PacketWrapper::readFloat);
                    this.explosionSound = new StaticSound(explosionSoundKey, explosionSoundRange);
                }
            }
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            Vector3d.write(this, this.position);
        } else {
            this.writeFloat((float)this.position.getX());
            this.writeFloat((float)this.position.getY());
            this.writeFloat((float)this.position.getZ());
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            this.writeOptional(this.knockback, Vector3d::write);
            Particle.write(this, this.particle);
            Sound.write(this, this.explosionSound);
        } else {
            this.writeFloat(this.strength);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
                this.writeVarInt(this.records.size());
            } else {
                this.writeInt(this.records.size());
            }
            Vector3i floor = this.toFloor(this.position);
            for (Vector3i record : this.records) {
                this.writeByte(record.x - floor.getX());
                this.writeByte(record.y - floor.getY());
                this.writeByte(record.z - floor.getZ());
            }
            this.writeFloat((float)this.knockback.x);
            this.writeFloat((float)this.knockback.y);
            this.writeFloat((float)this.knockback.z);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
                this.writeVarInt(this.blockInteraction.ordinal());
                Particle.write(this, this.smallParticle);
                Particle.write(this, this.particle);
                if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                    Sound.write(this, this.explosionSound);
                } else {
                    this.writeIdentifier(this.explosionSound.getSoundId());
                    this.writeOptional(this.explosionSound.getRange(), PacketWrapper::writeFloat);
                }
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerExplosion wrapper) {
        this.position = wrapper.position;
        this.strength = wrapper.strength;
        this.records = wrapper.records;
        this.knockback = wrapper.knockback;
        this.smallParticle = wrapper.smallParticle;
        this.particle = wrapper.particle;
        this.blockInteraction = wrapper.blockInteraction;
        this.explosionSound = wrapper.explosionSound;
    }

    private Vector3i toFloor(Vector3d position) {
        int floorZ;
        int floorY;
        int floorX;
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            floorX = (int)Math.floor(position.x);
            floorY = (int)Math.floor(position.y);
            floorZ = (int)Math.floor(position.z);
        } else {
            floorX = (int)position.x;
            floorY = (int)position.y;
            floorZ = (int)position.z;
        }
        return new Vector3i(floorX, floorY, floorZ);
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    @ApiStatus.Obsolete
    public float getStrength() {
        return this.strength;
    }

    @ApiStatus.Obsolete
    public void setStrength(float strength) {
        this.strength = strength;
    }

    @ApiStatus.Obsolete
    public List<Vector3i> getRecords() {
        return this.records;
    }

    @ApiStatus.Obsolete
    public void setRecords(List<Vector3i> records) {
        this.records = records;
    }

    @Nullable
    public Vector3d getKnockback() {
        return this.knockback;
    }

    public void setKnockback(@Nullable Vector3d knockback) {
        this.knockback = knockback;
    }

    @Deprecated
    @Nullable
    public Vector3f getPlayerMotion() {
        return this.knockback == null ? null : new Vector3f((float)this.knockback.x, (float)this.knockback.y, (float)this.knockback.z);
    }

    @Deprecated
    public void setPlayerMotion(@Nullable Vector3f playerMotion) {
        this.knockback = playerMotion == null ? null : new Vector3d(playerMotion.x, playerMotion.y, playerMotion.z);
    }

    @ApiStatus.Obsolete
    public Particle<?> getSmallExplosionParticles() {
        return this.smallParticle;
    }

    @ApiStatus.Obsolete
    public void setSmallExplosionParticles(Particle<?> smallExplosionParticles) {
        this.smallParticle = smallExplosionParticles;
    }

    public Particle<?> getParticle() {
        return this.particle;
    }

    public void setParticle(Particle<?> particle) {
        this.particle = particle;
    }

    @ApiStatus.Obsolete
    public Particle<?> getLargeExplosionParticles() {
        return this.getParticle();
    }

    @ApiStatus.Obsolete
    public void setLargeExplosionParticles(Particle<?> largeExplosionParticles) {
        this.setParticle(largeExplosionParticles);
    }

    @ApiStatus.Obsolete
    public BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    @ApiStatus.Obsolete
    public void setBlockInteraction(BlockInteraction blockInteraction) {
        this.blockInteraction = blockInteraction;
    }

    public ResourceLocation getExplosionSoundKey() {
        return this.explosionSound.getSoundId();
    }

    public void setExplosionSoundKey(ResourceLocation explosionSoundKey) {
        this.explosionSound = new StaticSound(explosionSoundKey, this.explosionSound.getRange());
    }

    @Nullable
    public Float getExplosionSoundRange() {
        return this.explosionSound.getRange();
    }

    public void setExplosionSoundRange(@Nullable Float explosionSoundRange) {
        this.explosionSound = new StaticSound(this.explosionSound.getSoundId(), explosionSoundRange);
    }

    public Sound getExplosionSound() {
        return this.explosionSound;
    }

    public void setExplosionSound(Sound explosionSound) {
        this.explosionSound = explosionSound;
    }

    public static enum BlockInteraction {
        KEEP_BLOCKS,
        DESTROY_BLOCKS,
        DECAY_DESTROYED_BLOCKS,
        TRIGGER_BLOCKS;

    }
}

