/*
 * Decompiled with CFR 0.152.
 */
package not.savage.shade.hologrambridge.hologram.impl;

import java.util.ArrayList;
import java.util.List;
import not.savage.shade.hologrambridge.connector.Connector;
import not.savage.shade.hologrambridge.hologram.Hologram;
import not.savage.shade.hologrambridge.hologram.VisibilityManager;
import not.savage.shade.hologrambridge.hologram.impl.OptimalVisibilityManager;
import not.savage.shade.hologrambridge.lines.Line;
import not.savage.shade.hologrambridge.lines.impl.OptimalItemLine;
import not.savage.shade.hologrambridge.lines.impl.OptimalTextLine;
import not.savage.shade.hologrambridge.lines.types.ItemLine;
import not.savage.shade.hologrambridge.lines.types.TextLine;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public final class OptimalHologram
implements Hologram {
    private final Connector connector;
    private final Object hologramObject;
    private final VisibilityManager visibilityManager;
    private final List<Line> lines = new ArrayList<Line>();
    private Location location;

    public OptimalHologram(Connector connector, Object hologramObject, Location location) {
        this.connector = connector;
        this.hologramObject = hologramObject;
        this.location = location;
        this.visibilityManager = new OptimalVisibilityManager(this, this.connector);
    }

    public List<Line> getLines() {
        return this.lines;
    }

    @Override
    public void clearLines() {
        this.lines.clear();
        this.connector.clearLines(this);
    }

    @Override
    public Line getLineAt(int index) {
        return this.lines.get(index);
    }

    @Override
    public int getLineIndex(Line line) {
        return this.lines.indexOf(line);
    }

    @Override
    public void setLineAt(int index, Line line) {
        this.lines.set(index, line);
        this.connector.setLine(this, index, line);
    }

    @Override
    public void updateLine(int index, Line line) {
        this.connector.updateLine(this, index, line);
    }

    @Override
    public void appendLine(Line line) {
        this.lines.add(line);
        this.connector.appendLine(this, line);
    }

    @Override
    public ItemLine appendItemLine(ItemStack itemStack) {
        OptimalItemLine itemLine = new OptimalItemLine(this, itemStack);
        this.appendLine(itemLine);
        return itemLine;
    }

    @Override
    public TextLine appendTextLine(String text) {
        OptimalTextLine textLine = new OptimalTextLine(this, text);
        this.appendLine(textLine);
        return textLine;
    }

    @Override
    public VisibilityManager getVisibilityManager() {
        return this.visibilityManager;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void teleport(Location location) {
        this.location = location;
        this.connector.teleport(this, location);
    }

    @Override
    public void delete() {
        this.connector.delete(this);
    }

    @Override
    public int size() {
        return this.lines.size();
    }

    @Override
    public double getHeight() {
        return this.connector.getHeight(this);
    }

    @Override
    public Object getHologramAsObject() {
        return this.hologramObject;
    }
}

