/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.shade.com.github.retrooper.packetevents.util;

import not.savage.airheads.shade.com.github.retrooper.packetevents.protocol.player.ClientVersion;

public class VersionMapper {
    private final ClientVersion[] versions;
    private final ClientVersion[] reversedVersions;

    public VersionMapper(ClientVersion ... versions) {
        this.versions = versions;
        this.reversedVersions = new ClientVersion[versions.length];
        int index = 0;
        for (int i = versions.length - 1; i >= 0; --i) {
            this.reversedVersions[index] = versions[i];
            ++index;
        }
    }

    public ClientVersion[] getVersions() {
        return this.versions;
    }

    public ClientVersion[] getReversedVersions() {
        return this.reversedVersions;
    }

    public int getIndex(ClientVersion version) {
        int index = this.reversedVersions.length - 1;
        for (ClientVersion v : this.reversedVersions) {
            if (version.isNewerThanOrEquals(v)) {
                return index;
            }
            --index;
        }
        return 0;
    }
}

