/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.tasks;

import not.savage.airheads.AirHeadEntity;
import org.bukkit.Location;
import org.bukkit.scheduler.BukkitRunnable;

public class FloatAnimationTask
extends BukkitRunnable {
    private final AirHeadEntity airHead;
    private final double minY;
    private final double maxY;
    private final double stepHeight;
    private final int rotationSpeed;
    private final boolean rotate;
    private final boolean floating;
    private final long initialDelay;
    private int rot = -180;
    private boolean goingUp = true;

    public FloatAnimationTask(Location origin, AirHeadEntity airHead, long initialDelay) {
        this.airHead = airHead;
        this.minY = origin.getY() - this.airHead.getConfig().getAnimationSettings().getFloatDownMax();
        this.maxY = origin.getY() + this.airHead.getConfig().getAnimationSettings().getFloatUpMax();
        double ticks = this.airHead.getConfig().getAnimationSettings().getFloatCycleDurationTicks();
        this.stepHeight = (this.maxY - this.minY) / (ticks / 2.0);
        this.rotationSpeed = this.airHead.getConfig().getAnimationSettings().getRotationPerTick();
        this.initialDelay = initialDelay;
        this.rotate = this.airHead.getConfig().getAnimationSettings().isDoRotation();
        this.floating = this.airHead.getConfig().getAnimationSettings().isDoFloat();
    }

    public void run() {
        if (System.currentTimeMillis() < this.initialDelay) {
            return;
        }
        Location curr = this.airHead.getCurrentLocation().clone();
        if (this.floating) {
            if (this.goingUp) {
                curr.add(0.0, this.stepHeight, 0.0);
                if (curr.getY() >= this.maxY) {
                    curr.setY(this.maxY);
                    this.goingUp = false;
                }
            } else {
                curr.subtract(0.0, this.stepHeight, 0.0);
                if (curr.getY() <= this.minY) {
                    curr.setY(this.minY);
                    this.goingUp = true;
                }
            }
        }
        if (this.rotate) {
            curr.setYaw((float)this.rot);
            this.rot += this.rotationSpeed;
            if (this.rot > 180) {
                this.rot = -180 + (this.rot - 180);
            }
        }
        this.airHead.teleport(curr);
    }
}

