/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import lombok.Generated;
import net.kyori.adventure.text.minimessage.MiniMessage;
import not.savage.airheads.config.AirHead;
import not.savage.airheads.tasks.AirHeadAnimationTask;
import not.savage.airheads.utility.Heads;
import not.savage.shade.hologrambridge.HologramAPI;
import not.savage.shade.hologrambridge.hologram.Hologram;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AirHeadEntity {
    public static final NamespacedKey KEY = new NamespacedKey("airheads", "armor_stand");
    private final AirHead config;
    private final Location location;
    private ArmorStand head;
    private int floatTask = -1;
    private Hologram hologram;
    private final long activeAfter;

    protected AirHeadEntity(AirHead config, long delayedTicks) {
        this.config = config;
        this.location = config.getLocation();
        this.activeAfter = System.currentTimeMillis() + delayedTicks * 50L;
    }

    public void spawnAirHead() {
        this.head = (ArmorStand)this.location.getWorld().spawnEntity(this.location, EntityType.ARMOR_STAND);
        this.head.setGravity(false);
        this.head.setBasePlate(false);
        this.head.setInvisible(true);
        this.head.setInvisible(true);
        this.head.setArms(false);
        this.head.getPersistentDataContainer().set(KEY, PersistentDataType.BOOLEAN, (Object)true);
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
        Heads.setBase64ToSkullMeta(this.config.getHeadTexture(), meta);
        playerHead.setItemMeta((ItemMeta)meta);
        this.head.setItem(EquipmentSlot.HEAD, playerHead);
        this.floatTask = new AirHeadAnimationTask(this.location, this, this.activeAfter).runTaskTimer((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), 0L, 1L).getTaskId();
        this.hologram = HologramAPI.createHologram(this.location.add(0.0, 3.0, 0.0));
        for (String line : this.config.getHologramText()) {
            this.hologram.appendTextLine(MiniMessage.miniMessage().deserialize((Object)line));
        }
    }

    public void remove() {
        if (this.floatTask != -1) {
            Bukkit.getScheduler().cancelTask(this.floatTask);
        }
        if (this.head != null) {
            this.head.remove();
        }
        if (this.hologram != null) {
            this.hologram.delete();
        }
    }

    @Generated
    public AirHead getConfig() {
        return this.config;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public ArmorStand getHead() {
        return this.head;
    }

    @Generated
    public int getFloatTask() {
        return this.floatTask;
    }

    @Generated
    public Hologram getHologram() {
        return this.hologram;
    }

    @Generated
    public long getActiveAfter() {
        return this.activeAfter;
    }
}

