/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import not.savage.airheads.AirHeadEntity;
import not.savage.airheads.commands.CmdAirHeads;
import not.savage.airheads.config.AirHead;
import not.savage.airheads.config.AirHeadsConfig;
import not.savage.airheads.listener.ArmorStandProtection;
import not.savage.airheads.utility.ConfigBuilder;
import not.savage.shade.hologrambridge.HologramBridge;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AirHeadsPlugin
extends JavaPlugin {
    private AirHeadsConfig airHeadsConfig;
    private final List<AirHeadEntity> entities = new ArrayList<AirHeadEntity>();

    public void onEnable() {
        Instant start = Instant.now();
        this.getLogger().info("Loading ShockAirHeads Plugin!");
        if (!this.setupHologramBridge()) {
            this.getLogger().severe("Failed to setup HologramBridge!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadConfig();
        this.getLogger().info("Loaded ShockAirHeads config from " + this.getDataFolder().getAbsolutePath() + "/config.yml");
        if (this.airHeadsConfig.isRunCleanupOnStart()) {
            this.getLogger().info("Cleaning up any stray AirHeads...");
            Bukkit.getWorlds().forEach(world -> world.getEntities().forEach(entity -> {
                if (entity.getPersistentDataContainer().has(AirHeadEntity.KEY, PersistentDataType.BOOLEAN)) {
                    this.getLogger().info("Removing stray AirHead entity... (x: " + entity.getLocation().getBlockX() + ", y: " + entity.getLocation().getBlockY() + ", z: " + entity.getLocation().getBlockZ() + ")");
                    entity.remove();
                }
            }));
        }
        this.spawnEntities();
        this.getLogger().info(String.format("Spawned all AirHeads (%d)", this.entities.size()));
        this.registerCommands();
        this.getLogger().info("Registered `/airheads reload` command.");
        new ArmorStandProtection(this);
        this.getLogger().info(String.format("ShockAirHeads Plugin loaded in %sms", Duration.between(start, Instant.now()).toMillis()));
    }

    public void onDisable() {
        this.getLogger().info("Shutting down Shock ShockAirHeads Plugin!");
        this.entities.forEach(AirHeadEntity::remove);
    }

    public Optional<AirHeadEntity> findAirHeadByEntity(ArmorStand armorStand) {
        return this.entities.stream().filter(entity -> entity.getHead().getUniqueId().equals(armorStand.getUniqueId())).findFirst();
    }

    public void reloadPlugin() {
        this.getLogger().info("Reloading ShockAirHeads Plugin!");
        this.loadConfig();
        this.entities.forEach(AirHeadEntity::remove);
        this.entities.clear();
        this.spawnEntities();
    }

    private void registerCommands() {
        PluginCommand command = this.getCommand("airheads");
        CmdAirHeads handler = new CmdAirHeads(this);
        if (command == null) {
            this.getLogger().severe("Failed to register command.");
            return;
        }
        command.setExecutor((CommandExecutor)handler);
        command.setTabCompleter((TabCompleter)handler);
    }

    private void loadConfig() {
        boolean failed;
        if (!this.getDataFolder().exists() && (failed = this.getDataFolder().mkdir())) {
            this.getLogger().severe("Failed to create data folder!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.airHeadsConfig = new ConfigBuilder<AirHeadsConfig>(AirHeadsConfig.class).withPath(new File(this.getDataFolder(), "config.yml").toPath()).build();
    }

    private void spawnEntities() {
        long offsetTicks;
        long offset = offsetTicks = this.airHeadsConfig.getFloatAnimationOffsetTicks();
        for (AirHead airHead : this.airHeadsConfig.getAirHeads()) {
            AirHeadEntity airHeadEntity = new AirHeadEntity(airHead, offset);
            airHeadEntity.spawnAirHead();
            this.entities.add(airHeadEntity);
            offset += offsetTicks;
        }
    }

    private boolean setupHologramBridge() {
        Plugin hologramBridge = Bukkit.getPluginManager().getPlugin("HologramBridge");
        if (hologramBridge != null && hologramBridge.isEnabled()) {
            this.getLogger().info("HologramBridge found!");
            return true;
        }
        try {
            Class.forName("not.savage.shade.hologrambridge.HologramAPI");
            this.initializeHologramBridge();
            return true;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().warning("You have installed the wrong version of Shock AirHeads! The AirHeads versioninstalled does not include HologramBridge, you are meant to have it installed yourself... if you dont want that, you can just download the version which includes it from https://github.com/Savag3life/ShockAirHeads");
            return false;
        }
    }

    private void initializeHologramBridge() {
        this.getLogger().info("Initializing internal HologramBridge...");
        new HologramBridge(this, false);
    }
}

