/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.listener;

import net.kyori.adventure.text.minimessage.MiniMessage;
import not.savage.airheads.AirHeadEntity;
import not.savage.airheads.AirHeadsPlugin;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ArmorStandProtection
implements Listener {
    private final AirHeadsPlugin plugin;

    public ArmorStandProtection(AirHeadsPlugin plugin) {
        this.plugin = plugin;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler
    public void onArmorStandInteract(PlayerInteractAtEntityEvent event) {
        if (this.isProtectedArmorStand(event.getRightClicked())) {
            event.setCancelled(true);
            this.plugin.findAirHeadByEntity((ArmorStand)event.getRightClicked()).ifPresent(airHead -> {
                airHead.getConfig().getInteractCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)cmd));
                airHead.getConfig().getConsoleCommands().forEach(cmd -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%player%", event.getPlayer().getName())));
                if (!airHead.getConfig().getInteractMessage().isEmpty()) {
                    airHead.getConfig().getInteractMessage().forEach(line -> event.getPlayer().sendMessage(MiniMessage.miniMessage().deserialize(line)));
                }
                if (airHead.getConfig().getSoundSettings().isEnabled()) {
                    event.getPlayer().playSound((Entity)event.getPlayer(), airHead.getConfig().getSoundSettings().getSound(), airHead.getConfig().getSoundSettings().getVolume(), airHead.getConfig().getSoundSettings().getPitch());
                }
            });
        }
    }

    @EventHandler
    public void onArmorStandInteract(PlayerArmorStandManipulateEvent event) {
        event.setCancelled(this.isProtectedArmorStand((Entity)event.getRightClicked()));
    }

    @EventHandler
    public void onArmorStandDamage(EntityDamageByEntityEvent event) {
        event.setCancelled(this.isProtectedArmorStand(event.getEntity()));
    }

    private boolean isProtectedArmorStand(Entity armorStand) {
        return armorStand instanceof ArmorStand && armorStand.getPersistentDataContainer().has(AirHeadEntity.KEY, PersistentDataType.BOOLEAN);
    }
}

