/*
 * Decompiled with CFR 0.152.
 */
package not.savage.airheads.utility.adapter;

import java.lang.reflect.Type;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class LocationConfigAdapter
implements TypeSerializer<Location> {
    private final String LOCATION_WORLD_NODE = "world";
    private final String LOCATION_X_POS_NODE = "x";
    private final String LOCATION_Y_POS_NODE = "y";
    private final String LOCATION_Z_POS_NODE = "z";

    public Location deserialize(Type type, ConfigurationNode value) throws SerializationException {
        NamespacedKey worldKey = (NamespacedKey)value.node(new Object[]{"world"}).get(NamespacedKey.class);
        if (worldKey == null) {
            throw new SerializationException("Invalid world key");
        }
        double x = this.getValueIfPresent(value, "x", Double.class, 0.0);
        double y = this.getValueIfPresent(value, "y", Double.class, 0.0);
        double z = this.getValueIfPresent(value, "z", Double.class, 0.0);
        return new Location(Bukkit.getWorld((NamespacedKey)worldKey), x, y, z);
    }

    public void serialize(Type type, @Nullable Location obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        node.node(new Object[]{"world"}).set((Object)obj.getWorld().getKey());
        node.node(new Object[]{"x"}).set((Object)obj.getX());
        node.node(new Object[]{"y"}).set((Object)obj.getY());
        node.node(new Object[]{"z"}).set((Object)obj.getZ());
    }

    private <V> V getValueIfPresent(ConfigurationNode node, String field, Class<V> type, V defValue) throws SerializationException {
        if (!node.hasChild(new Object[]{field})) {
            return defValue;
        }
        return (V)node.node(new Object[]{field}).get(type);
    }
}

