/*
 * Decompiled with CFR 0.152.
 */
package not.savage.shade.hologrambridge;

import not.savage.shade.hologrambridge.HologramAPI;
import not.savage.shade.hologrambridge.connector.impl.CMIImpl;
import not.savage.shade.hologrambridge.connector.impl.DecentImpl;
import not.savage.shade.hologrambridge.connector.impl.HologramsImpl;
import not.savage.shade.hologrambridge.connector.impl.HolographicDisplaysImpl;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public final class HologramBridge {
    private final JavaPlugin javaPlugin;
    private final boolean verbose;

    public HologramBridge(JavaPlugin javaPlugin) {
        this(javaPlugin, false);
    }

    public HologramBridge(JavaPlugin javaPlugin, boolean verbose) {
        this.javaPlugin = javaPlugin;
        this.verbose = verbose;
        HologramAPI.setJavaPlugin(this.javaPlugin);
        this.checkConnectors();
    }

    private void checkConnectors() {
        if (this.isEnabled("HolographicDisplays")) {
            this.log("Found HolographicDisplays Connector");
            HologramAPI.setConnector(new HolographicDisplaysImpl(this, this.javaPlugin));
        }
        if (this.isEnabled("CMI")) {
            this.log("Found CMI Connector");
            HologramAPI.setConnector(new CMIImpl());
        }
        if (this.isEnabled("Holograms")) {
            this.log("Found Holograms Connector");
            HologramAPI.setConnector(new HologramsImpl());
        }
        if (this.isEnabled("DecentHolograms")) {
            this.log("Found DecentHolograms Connector");
            HologramAPI.setConnector(new DecentImpl());
        }
    }

    private boolean isEnabled(String plugin) {
        return Bukkit.getServer().getPluginManager().isPluginEnabled(plugin);
    }

    public void log(String text) {
        if (!this.verbose) {
            return;
        }
        this.javaPlugin.getLogger().info(text);
    }
}

