/*
 * Decompiled with CFR 0.152.
 */
package not.savage.shade.hologrambridge.connector.impl;

import com.sainttx.holograms.api.Hologram;
import com.sainttx.holograms.api.line.HologramLine;
import com.sainttx.holograms.api.line.ItemLine;
import java.util.Optional;
import java.util.UUID;
import not.savage.shade.hologrambridge.connector.Connector;
import not.savage.shade.hologrambridge.hologram.VisibilityManager;
import not.savage.shade.hologrambridge.hologram.impl.OptimalHologram;
import not.savage.shade.hologrambridge.lines.Line;
import not.savage.shade.hologrambridge.lines.types.TextLine;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class HologramsImpl
implements Connector {
    @Override
    public not.savage.shade.hologrambridge.hologram.Hologram createHologram(Location location) {
        return new OptimalHologram(this, new Hologram(UUID.randomUUID().toString(), location, false), location);
    }

    @Override
    public void setLine(not.savage.shade.hologrambridge.hologram.Hologram hologram, int lineIndex, Line line) {
        Optional<Hologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        Hologram saintHologram = hologramOptional.get();
        saintHologram.removeLine(saintHologram.getLine(lineIndex));
        if (line instanceof not.savage.shade.hologrambridge.lines.types.ItemLine) {
            saintHologram.addLine((HologramLine)new ItemLine(saintHologram, ((not.savage.shade.hologrambridge.lines.types.ItemLine)line).getItemStack()), lineIndex);
            return;
        }
        if (line instanceof TextLine) {
            saintHologram.addLine((HologramLine)new com.sainttx.holograms.api.line.TextLine(saintHologram, ((TextLine)line).getText()), lineIndex);
        }
    }

    @Override
    public void updateLine(not.savage.shade.hologrambridge.hologram.Hologram hologram, int lineIndex, Line line) {
        Optional<Hologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        Hologram saintHologram = hologramOptional.get();
        HologramLine hologramLine = saintHologram.getLine(lineIndex);
        if (line instanceof not.savage.shade.hologrambridge.lines.types.ItemLine && hologramLine instanceof ItemLine) {
            ItemStack itemStack = ((not.savage.shade.hologrambridge.lines.types.ItemLine)line).getItemStack();
            ((ItemLine)hologramLine).setItem(itemStack);
            return;
        }
        if (line instanceof TextLine && hologramLine instanceof com.sainttx.holograms.api.line.TextLine) {
            String text = ((TextLine)line).getText();
            ((com.sainttx.holograms.api.line.TextLine)hologramLine).setText(text);
        }
    }

    @Override
    public void appendLine(not.savage.shade.hologrambridge.hologram.Hologram hologram, Line line) {
        Optional<Hologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        Hologram saintHologram = hologramOptional.get();
        if (line instanceof not.savage.shade.hologrambridge.lines.types.ItemLine) {
            saintHologram.addLine((HologramLine)new ItemLine(saintHologram, ((not.savage.shade.hologrambridge.lines.types.ItemLine)line).getItemStack()));
            return;
        }
        if (line instanceof TextLine) {
            saintHologram.addLine((HologramLine)new com.sainttx.holograms.api.line.TextLine(saintHologram, ((TextLine)line).getText()));
        }
    }

    @Override
    public void clearLines(not.savage.shade.hologrambridge.hologram.Hologram hologram) {
        Optional<Hologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        Hologram saintHologram = hologramOptional.get();
        for (HologramLine hologramLine : saintHologram.getLines()) {
            saintHologram.removeLine(hologramLine);
        }
    }

    @Override
    public void teleport(not.savage.shade.hologrambridge.hologram.Hologram hologram, Location location) {
        Optional<Hologram> hologramOptional = this.getHologram(hologram);
        if (!hologramOptional.isPresent()) {
            return;
        }
        Hologram saintHologram = hologramOptional.get();
        saintHologram.teleport(location);
    }

    @Override
    public void delete(not.savage.shade.hologrambridge.hologram.Hologram hologram) {
        Optional<Hologram> hologramOptional = this.getHologram(hologram);
        hologramOptional.ifPresent(Hologram::despawn);
    }

    @Override
    public void setVisibleByDefault(VisibilityManager visibilityManager, boolean visibleByDefault) {
        throw new UnsupportedOperationException("Holograms does not support per-player holograms!");
    }

    @Override
    public void showTo(VisibilityManager visibilityManager, Player player) {
        throw new UnsupportedOperationException("Holograms does not support per-player holograms!");
    }

    @Override
    public void hideTo(VisibilityManager visibilityManager, Player player) {
        throw new UnsupportedOperationException("Holograms does not support per-player holograms!");
    }

    @Override
    public double getHeight(not.savage.shade.hologrambridge.hologram.Hologram hologram) {
        throw new UnsupportedOperationException("Holograms does not support getting the height!");
    }

    private Optional<Hologram> getHologram(not.savage.shade.hologrambridge.hologram.Hologram hologram) {
        Object hologramObject = hologram.getHologramAsObject();
        if (hologramObject instanceof Hologram) {
            return Optional.of((Hologram)hologramObject);
        }
        return Optional.empty();
    }
}

