/*
 * Decompiled with CFR 0.152.
 */
package not.savage.shade.hologrambridge.hologram.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import not.savage.shade.hologrambridge.connector.Connector;
import not.savage.shade.hologrambridge.hologram.Hologram;
import not.savage.shade.hologrambridge.hologram.VisibilityManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class OptimalVisibilityManager
implements VisibilityManager {
    private final List<UUID> viewers = new ArrayList<UUID>();
    private final Hologram hologram;
    private final Connector connector;
    private boolean visibleByDefault;

    public OptimalVisibilityManager(Hologram hologram, Connector connector) {
        this.hologram = hologram;
        this.connector = connector;
        this.visibleByDefault = true;
    }

    @Override
    public Hologram getHologram() {
        return this.hologram;
    }

    @Override
    public boolean isVisibleByDefault() {
        return this.visibleByDefault;
    }

    @Override
    public void setVisibleByDefault(boolean visibleByDefault) {
        this.visibleByDefault = visibleByDefault;
        this.connector.setVisibleByDefault(this, visibleByDefault);
    }

    @Override
    public void showTo(Player player) {
        this.viewers.add(player.getUniqueId());
        this.connector.showTo(this, player);
    }

    @Override
    public void hideTo(Player player) {
        this.viewers.remove(player.getUniqueId());
        this.connector.hideTo(this, player);
    }

    @Override
    public boolean isVisibleTo(Player player) {
        return this.viewers.contains(player.getUniqueId());
    }

    @Override
    public void resetVisibility(Player player) {
        if (this.visibleByDefault) {
            this.viewers.add(player.getUniqueId());
            this.connector.showTo(this, player);
            return;
        }
        this.viewers.remove(player.getUniqueId());
        this.connector.hideTo(this, player);
    }

    @Override
    public void resetVisibilityAll() {
        Bukkit.getOnlinePlayers().forEach(this::resetVisibility);
    }
}

