/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.utils.ChunkVectorizer;
import com.magmaguy.elitemobs.utils.PersistentVanillaData;
import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CrashFix
implements Listener {
    private static final HashSet<Integer> temporarilyCachedChunks = new HashSet();
    public static String key = "EliteMobsCullable";
    public static String fallingBlocksKey = "VisualFallingBlocks";
    public static HashSet<Integer> knownSessionChunks = new HashSet();

    public static void persistentTracker(Entity entity) {
        PersistentVanillaData.write(entity, key, "delete_me");
    }

    public static void registerVisualFallingBlock(Entity entity) {
        PersistentVanillaData.write(entity, fallingBlocksKey, "delete_me");
    }

    public static boolean isPersistentEntity(Entity entity) {
        return PersistentVanillaData.hasString(entity, key);
    }

    public static boolean isVisualFallingBlock(Entity entity) {
        return PersistentVanillaData.hasString(entity, fallingBlocksKey);
    }

    public static void startupCheck() {
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                CrashFix.chunkCheck(chunk);
                knownSessionChunks.add(ChunkVectorizer.hash(chunk));
            }
        }
    }

    private static void chunkCheck(Chunk chunk) {
        for (Entity entity : chunk.getEntities()) {
            if (!CrashFix.isPersistentEntity(entity)) continue;
            entity.remove();
        }
    }

    private static void delayedChunkCheck(Chunk chunk, final int hashedChunk) {
        final Entity[] entities = (Entity[])chunk.getEntities().clone();
        new BukkitRunnable(){

            public void run() {
                for (Entity entity : entities) {
                    if (!CrashFix.isPersistentEntity(entity)) continue;
                    entity.remove();
                }
                temporarilyCachedChunks.remove(hashedChunk);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        int hashedChunk = ChunkVectorizer.hash(event.getChunk());
        if (temporarilyCachedChunks.contains(hashedChunk)) {
            return;
        }
        temporarilyCachedChunks.add(hashedChunk);
        if (knownSessionChunks.contains(hashedChunk)) {
            return;
        }
        knownSessionChunks.add(hashedChunk);
        CrashFix.delayedChunkCheck(event.getChunk(), hashedChunk);
    }
}

