/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.QuestsConfig;
import com.magmaguy.elitemobs.config.SoundsConfig;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.QuestTracking;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class QuestLeaveEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final Quest quest;

    public QuestLeaveEvent(Player player, Quest quest) {
        this.player = player;
        this.quest = quest;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public Quest getQuest() {
        return this.quest;
    }

    public static class QuestLeaveEventHandler
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onQuestLeave(QuestLeaveEvent event) {
            Quest quest;
            PlayerData.removeQuest(event.getPlayer().getUniqueId(), event.getQuest());
            event.getPlayer().sendMessage(QuestsConfig.getQuestLeaveMessage().replace("$questName", event.getQuest().getQuestName()));
            if (QuestsConfig.isUseQuestLeaveTitles()) {
                event.getPlayer().sendTitle(QuestsConfig.getQuestLeaveTitle().replace("$questName", event.getQuest().getQuestName()), QuestsConfig.getQuestLeaveSubtitle().replace("$questName", event.getQuest().getQuestName()), 20, 60, 20);
            }
            if ((quest = event.getQuest()) instanceof CustomQuest) {
                QuestTracking questTracking;
                CustomQuest customQuest = (CustomQuest)quest;
                if (!customQuest.getCustomQuestsConfigFields().getTemporaryPermissions().isEmpty()) {
                    PermissionAttachment permissionAttachment = event.getPlayer().addAttachment((Plugin)MetadataHandler.PLUGIN);
                    for (String permission : customQuest.getCustomQuestsConfigFields().getTemporaryPermissions()) {
                        permissionAttachment.setPermission(permission, false);
                    }
                }
                if (QuestTracking.getPlayerTrackingQuests().containsKey(event.getPlayer()) && (questTracking = QuestTracking.getPlayerTrackingQuests().get(event.getPlayer())).getCustomQuest().getCustomQuestsConfigFields().equals(customQuest.getCustomQuestsConfigFields())) {
                    questTracking.stop();
                }
            }
            event.getPlayer().playSound(event.getPlayer().getLocation(), SoundsConfig.questAbandonSound, 1.0f, 1.0f);
        }
    }
}

