/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.commands.SpawnCommand;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.SenderType;
import com.magmaguy.magmacore.command.arguments.DoubleCommandArgument;
import com.magmaguy.magmacore.command.arguments.EntityTypeCommandArgument;
import com.magmaguy.magmacore.command.arguments.IntegerCommandArgument;
import com.magmaguy.magmacore.command.arguments.ListStringCommandArgument;
import com.magmaguy.magmacore.command.arguments.WorldCommandArgument;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;

public class SpawnEliteAtCommand
extends AdvancedCommand {
    public SpawnEliteAtCommand() {
        super(List.of("spawn"));
        this.addLiteral("eliteAt");
        this.addArgument("world", new WorldCommandArgument("<world>"));
        this.addArgument("x", new DoubleCommandArgument("<x>"));
        this.addArgument("y", new DoubleCommandArgument("<y>"));
        this.addArgument("z", new DoubleCommandArgument("<z>"));
        this.addArgument("entityType", new EntityTypeCommandArgument());
        this.addArgument("level", new IntegerCommandArgument("<level>"));
        this.addArgument("powers", new ListStringCommandArgument(ElitePower.getElitePowers().keySet().stream().toList(), "<powers>"));
        this.setUsage("/em spawn eliteAt <world> <x> <y> <z> <entityType> <level> <power1> <power2> <power3> <...>");
        this.setPermission("elitemobs.place.admin");
        this.setSenderType(SenderType.PLAYER);
        this.setDescription("Spawns an elite of the specified type and level, optionally with specified powers, at the chosen location.");
    }

    @Override
    public void execute(CommandData commandData) {
        SpawnCommand.spawnEliteEntityTypeCommand((CommandSender)commandData.getPlayerSender(), EntityType.valueOf((String)commandData.getStringArgument("entityType")), commandData.getStringArgument("world"), new Vector(commandData.getIntegerArgument("x").intValue(), commandData.getIntegerArgument("y").intValue(), commandData.getIntegerArgument("z").intValue()), commandData.getIntegerArgument("level"), Optional.of(commandData.getStringSequenceArgument("powers")));
    }
}

