/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config;

import com.magmaguy.elitemobs.config.ConfigurationEngine;
import com.magmaguy.elitemobs.quests.objectives.CustomFetchObjective;
import com.magmaguy.elitemobs.quests.objectives.DialogObjective;
import com.magmaguy.elitemobs.quests.objectives.KillObjective;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import com.magmaguy.magmacore.config.ConfigurationFile;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;

public class QuestsConfig
extends ConfigurationFile {
    private static boolean requireQuestTurnIn;
    private static String questJoinMessage;
    private static String questLeaveMessage;
    private static String questCompleteMessage;
    private static String leaveWhenNoActiveQuestsExist;
    private static String questLeaveConfirmationMessage;
    private static boolean useQuestAcceptTitles;
    private static String questStartTitle;
    private static String questStartSubtitle;
    private static boolean useQuestCompleteTitles;
    private static String questCompleteTitle;
    private static String questCompleteSubtitle;
    private static boolean useQuestLeaveTitles;
    private static String questLeaveTitle;
    private static String questLeaveSubtitle;
    private static boolean doQuestChatProgression;
    private static String ongoingColorCode;
    private static String completedColorCode;
    private static String killQuestChatProgressionMessage;
    private static String fetchQuestChatProgressionMessage;
    private static String dialogQuestChatProgressionMessage;
    private static boolean useQuestScoreboards;
    private static String killQuestScoreboardProgressionLine;
    private static String fetchQuestScoreboardProgressionLine;
    private static String dialogQuestScoreboardProgressionLine;
    private static int maximumActiveQuests;
    private static String questCapMessage;
    private static List<EntityType> questEntityTypes;
    private static String chatTrackMessage;
    private static String chatTrackHover;
    private static String chatTrackCommand;
    private static String chatTrackingMessage;
    private static String chatTrackingHover;
    private static String chatTrackingCommand;
    private static boolean autoTrackQuestsOnAccept;
    private static String noQuestDestinationFound;
    private static String questDestinationInOtherWorld;
    private static String questAlreadyCompletedMessage;
    private static String questPrerequisitesMissingMessage;
    private static String lowRankDynamicQuestWarning;
    private static String questTurnInObjective;
    private static int horizontalCharacterLimitBedrockMenu;
    private static int itemEntryCharacterLimitBedrockMenu;

    public QuestsConfig() {
        super("Quests.yml");
    }

    private static List<EntityType> setEntityTypes(FileConfiguration fileConfiguration, File file) {
        ArrayList<String> entityTypes = new ArrayList<String>(new ArrayList<String>(List.of(EntityType.BLAZE.toString(), EntityType.CAVE_SPIDER.toString(), EntityType.DROWNED.toString(), EntityType.ELDER_GUARDIAN.toString(), EntityType.ENDERMAN.toString(), EntityType.ENDERMITE.toString(), EntityType.EVOKER.toString(), EntityType.GHAST.toString(), EntityType.GUARDIAN.toString(), EntityType.HUSK.toString(), EntityType.ILLUSIONER.toString(), EntityType.IRON_GOLEM.toString(), EntityType.PILLAGER.toString(), EntityType.RAVAGER.toString(), EntityType.SILVERFISH.toString(), EntityType.SKELETON.toString(), EntityType.SPIDER.toString(), EntityType.STRAY.toString(), EntityType.VINDICATOR.toString(), EntityType.WITCH.toString(), EntityType.WITHER_SKELETON.toString(), EntityType.WOLF.toString(), EntityType.ZOMBIE.toString())));
        ArrayList<String> laterEntities = new ArrayList<String>(List.of(EntityType.HOGLIN.toString(), EntityType.ZOGLIN.toString(), EntityType.PIGLIN_BRUTE.toString(), EntityType.PIGLIN.toString(), EntityType.ZOMBIFIED_PIGLIN.toString()));
        entityTypes.addAll(laterEntities);
        ConfigurationEngine.setList(file, fileConfiguration, "questEntityTypes", entityTypes, false);
        ArrayList<EntityType> parsedTypes = new ArrayList<EntityType>();
        for (String string : entityTypes) {
            try {
                parsedTypes.add(EntityType.valueOf((String)string));
            }
            catch (Exception ex) {
                Logger.warn("Entity type " + string + " is not a valid entity type from the Spigot API!");
            }
        }
        return parsedTypes;
    }

    public static String getQuestChatProgressionMessage(Objective objective) {
        String newString = "";
        if (objective instanceof KillObjective) {
            newString = killQuestChatProgressionMessage;
        } else if (objective instanceof CustomFetchObjective) {
            newString = fetchQuestChatProgressionMessage;
        } else if (objective instanceof DialogObjective) {
            newString = dialogQuestChatProgressionMessage;
        }
        newString = newString.replace("$name", ChatColor.WHITE + ChatColor.stripColor((String)objective.getObjectiveName()));
        newString = newString.replace("$current", "" + objective.getCurrentAmount());
        newString = newString.replace("$target", "" + objective.getTargetAmount());
        if (!objective.isObjectiveCompleted()) {
            return newString.replace("$color", ongoingColorCode);
        }
        return newString.replace("$color", completedColorCode);
    }

    public static String getQuestScoreboardProgressionLine(Objective objective) {
        if (objective == null) {
            Logger.warn("Objective is null!");
        }
        String newString = "";
        if (objective instanceof KillObjective) {
            newString = killQuestScoreboardProgressionLine;
        } else if (objective instanceof CustomFetchObjective) {
            newString = fetchQuestScoreboardProgressionLine;
        } else if (objective instanceof DialogObjective) {
            newString = dialogQuestScoreboardProgressionLine;
        }
        newString = newString.replace("$name", ChatColor.WHITE + ChatColor.stripColor((String)objective.getObjectiveName()));
        newString = newString.replace("$current", "" + objective.getCurrentAmount());
        newString = newString.replace("$target", "" + objective.getTargetAmount());
        if (!objective.isObjectiveCompleted()) {
            return newString.replace("$color", ongoingColorCode);
        }
        return newString.replace("$color", completedColorCode);
    }

    @Override
    public void initializeValues() {
        requireQuestTurnIn = ConfigurationEngine.setBoolean(List.of("Sets if quests have to be returned to quest givers to complete the quest."), this.fileConfiguration, "requireQuestTurnIn", true);
        questJoinMessage = ConfigurationEngine.setString(List.of("Sets the message sent when a quest is accepted."), this.file, this.fileConfiguration, "questJoinMessage", "&aYou have accepted the quest $questName &a!", true);
        questLeaveMessage = ConfigurationEngine.setString(List.of("Sets the message sent when a quest is abandoned."), this.file, this.fileConfiguration, "questLeaveMessage", "&cYou have abandoned the quest $questName &c!", true);
        questCompleteMessage = ConfigurationEngine.setString(List.of("Sets message sent when a quest is completed."), this.file, this.fileConfiguration, "questCompleteMessage", "&2You completed the quest $questName &2!", true);
        leaveWhenNoActiveQuestsExist = ConfigurationEngine.setString(List.of("Sets the message sent when a player tried to abandon a quest when none are active."), this.file, this.fileConfiguration, "leaveWhenNoActiveQuestsExist", "&cYou don't currently have an active quest!", true);
        questLeaveConfirmationMessage = ConfigurationEngine.setString(List.of("Sets the confirmation message sent when players try to leave a quest."), this.file, this.fileConfiguration, "questLeaveConfirmationMessage", "&cAre you sure you want to abandon your current quest? Do &a/em confirm &c to confirm your choice!", true);
        useQuestAcceptTitles = ConfigurationEngine.setBoolean(List.of("Sets if some of the messages related to quests will use titles instead of chat messages."), this.fileConfiguration, "useQuestAcceptTitles", true);
        questStartTitle = ConfigurationEngine.setString(List.of("Sets the title sent when a players starts a quest."), this.file, this.fileConfiguration, "questStartTitle", "&aQuest Accepted!", true);
        questStartSubtitle = ConfigurationEngine.setString(List.of("Sets the subtitle sent when a players starts a quest."), this.file, this.fileConfiguration, "questStartSubtitle", "$questName", false);
        useQuestCompleteTitles = ConfigurationEngine.setBoolean(List.of("Sets if titles will be sent when players complete a quest."), this.fileConfiguration, "useQuestCompleteTitles", true);
        questCompleteTitle = ConfigurationEngine.setString(List.of("Sets the title sent when a player completes a quest."), this.file, this.fileConfiguration, "questCompleteTitle", "&2Quest Completed!", true);
        questCompleteSubtitle = ConfigurationEngine.setString(List.of("Sets the subtitle sent when a player completes a quest."), this.file, this.fileConfiguration, "questCompleteSubtitle", "$questName", true);
        useQuestLeaveTitles = ConfigurationEngine.setBoolean(List.of("Sets if titles are sent when players leave quests.."), this.fileConfiguration, "useQuestLeaveTitles", true);
        questLeaveTitle = ConfigurationEngine.setString(List.of("Sets the title sent when a player leaves a quest."), this.file, this.fileConfiguration, "questLeaveTitle", "&cQuest Abandoned!", true);
        questLeaveSubtitle = ConfigurationEngine.setString(List.of("Sets the subtitle sent when a player leaves a quest."), this.file, this.fileConfiguration, "questLeaveSubtitle", "$questName", false);
        doQuestChatProgression = ConfigurationEngine.setBoolean(List.of("Sets if messages are sent on chat reporting quest objective progression."), this.fileConfiguration, "doQuestChatProgression", true);
        ongoingColorCode = ConfigurationEngine.setString(List.of("Sets the color codes for ongoing objectives."), this.file, this.fileConfiguration, "ongoingQuestColorCode", "&c", false);
        completedColorCode = ConfigurationEngine.setString(List.of("Sets the color codes for completed objectives."), this.file, this.fileConfiguration, "ongoingQuestColorCode", "&2", false);
        killQuestChatProgressionMessage = ConfigurationEngine.setString(List.of("Sets the formatting for progression messages of kill quests."), this.file, this.fileConfiguration, "killQuestChatProgressionMessage", "&8[EliteMobs]&c\u27a4Kill $name:$color$current&0/$color$target", true);
        fetchQuestChatProgressionMessage = ConfigurationEngine.setString(List.of("Sets the formatting for progression messages of fetch quests."), this.file, this.fileConfiguration, "fetchQuestChatProgressionMessage", "&8[EliteMobs]&c\u27a4Get $name:$color$current&0/$color$target", true);
        dialogQuestChatProgressionMessage = ConfigurationEngine.setString(List.of("Sets the formatting for progression messages of dialog quests."), this.file, this.fileConfiguration, "dialogQuestChatProgressionMessage", "&8[EliteMobs]&c\u27a4Talk to $name:$color$current&0/$color$target", true);
        maximumActiveQuests = ConfigurationEngine.setInt(List.of("Sets the maximum amount of accepted quests a player can have."), this.fileConfiguration, "maximumActiveQuests", 10);
        questCapMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players when trying to accept an amount of quests that exceed the active quest cap."), this.file, this.fileConfiguration, "questCapMessage", "&8[EliteMobs] &cYou have reached the maximum amount of active quests (10)! &4Abandon or complete at least one active quest if you want to get more quests!", true);
        useQuestScoreboards = ConfigurationEngine.setBoolean(List.of("Sets if scoreboards messages will be used for quests."), this.fileConfiguration, "useQuestScoreboards", true);
        killQuestScoreboardProgressionLine = ConfigurationEngine.setString(List.of("Sets the formatting for scoreboard progression messages of kill quests."), this.file, this.fileConfiguration, "killQuestScoreboardProgressionMessage", "&c\u27a4Kill $name:$color$current&0/$color$target", true);
        fetchQuestScoreboardProgressionLine = ConfigurationEngine.setString(List.of("Sets the formatting for scoreboard progression message of fetch quests."), this.file, this.fileConfiguration, "fetchQuestScoreboardProgressionMessage", "&c\u27a4Get $name:$color$current&0/$color$target", true);
        dialogQuestScoreboardProgressionLine = ConfigurationEngine.setString(List.of("Sets the formatting for scoreboard progression messages of dialog quests."), this.file, this.fileConfiguration, "dialogQuestScoreboardProgressionMessage", "&c\u27a4Talk to $name:$color$current&0/$color$target", true);
        questEntityTypes = QuestsConfig.setEntityTypes(this.fileConfiguration, this.file);
        chatTrackMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players to activate quest tracking."), this.file, this.fileConfiguration, "chatTrackMessage", "&8[EliteMobs]&2 Click here to track your quest!", true);
        chatTrackHover = ConfigurationEngine.setString(List.of("Sets the hover message of the quest tracking message."), this.file, this.fileConfiguration, "chatTrackHover", "&2Click to track!", true);
        chatTrackCommand = ConfigurationEngine.setString(List.of("Sets the command sent when clicking on the tracking message. You really should not modify this."), this.file, this.fileConfiguration, "chatTrackCommand", "/elitemobs quest track $questID", false);
        chatTrackingMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players when activating quest tracking."), this.file, this.fileConfiguration, "chatTrackingMessage", "&8[EliteMobs]&9 You are now tracking a quest!", true);
        chatTrackingHover = ConfigurationEngine.setString(List.of("Sets the hover message of the quest tracking enabled message."), this.file, this.fileConfiguration, "chatTrackingHover", "&2Click to untrack/track! /em -> Quests to track a different quest!", true);
        chatTrackingCommand = ConfigurationEngine.setString(List.of("Sets the command sent when click on the quest tracking activation message. You really should not modify this."), this.file, this.fileConfiguration, "chatTrackingCommand", "/elitemobs quest track $questID", false);
        autoTrackQuestsOnAccept = ConfigurationEngine.setBoolean(List.of("Sets if quests are automatically tracked when accepted."), this.fileConfiguration, "autoTrackQuestsOnAccept", true);
        noQuestDestinationFound = ConfigurationEngine.setString(List.of("Sets the message that appears when the destination of the quest could not be found."), this.file, this.fileConfiguration, "noQuestDestinationFound", "[EM] No quest destination found!", true);
        questDestinationInOtherWorld = ConfigurationEngine.setString(List.of("Sets the message that appears when the quest target is in a different world."), this.file, this.fileConfiguration, "questDestinationInOtherWorld", "[EM] Go to world $world!", true);
        questAlreadyCompletedMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players when trying to accept a quest they have already completed."), this.file, this.fileConfiguration, "questAlreadyCompletedMessage", "&8[EliteMobs] &cYou already completed this quest!", true);
        questPrerequisitesMissingMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players when trying to accept a quest they do not have the permission for."), this.file, this.fileConfiguration, "questPrerequisitesMissingMessage", "&8[EliteMobs] &cThis NPC has some quest(s) you can't accept yet!", true);
        lowRankDynamicQuestWarning = ConfigurationEngine.setString(List.of("Sets the message sent to players trying to get a quest for which they do not have the correct guild rank activated."), this.file, this.fileConfiguration, "lowRankDynamicQuestWarning", "&8[EliteMobs] &cYou can't take these quests with your current guild rank! Increase your guild rank to accept these quests.", true);
        questTurnInObjective = ConfigurationEngine.setString(List.of("Sets the formatting for the quest turn-in message."), this.file, this.fileConfiguration, "questTurnInObjective", "&a2Talk to $npcName", true);
        horizontalCharacterLimitBedrockMenu = ConfigurationEngine.setInt(List.of("Sets the maximum amount of characters inventory-based menus for quests will have before breaking the line."), this.fileConfiguration, "horizontalCharacterLimitBedrockMenu", 30);
        itemEntryCharacterLimitBedrockMenu = ConfigurationEngine.setInt(List.of("Sets the maximum amount of characters per item entry in inventory-based menus for quests before creating another item to continue the entry."), this.fileConfiguration, "itemEntryCharacterLimitBedrockMenu", 300);
    }

    @Generated
    public static boolean isRequireQuestTurnIn() {
        return requireQuestTurnIn;
    }

    @Generated
    public static String getQuestJoinMessage() {
        return questJoinMessage;
    }

    @Generated
    public static String getQuestLeaveMessage() {
        return questLeaveMessage;
    }

    @Generated
    public static String getQuestCompleteMessage() {
        return questCompleteMessage;
    }

    @Generated
    public static String getLeaveWhenNoActiveQuestsExist() {
        return leaveWhenNoActiveQuestsExist;
    }

    @Generated
    public static String getQuestLeaveConfirmationMessage() {
        return questLeaveConfirmationMessage;
    }

    @Generated
    public static boolean isUseQuestAcceptTitles() {
        return useQuestAcceptTitles;
    }

    @Generated
    public static String getQuestStartTitle() {
        return questStartTitle;
    }

    @Generated
    public static String getQuestStartSubtitle() {
        return questStartSubtitle;
    }

    @Generated
    public static boolean isUseQuestCompleteTitles() {
        return useQuestCompleteTitles;
    }

    @Generated
    public static String getQuestCompleteTitle() {
        return questCompleteTitle;
    }

    @Generated
    public static String getQuestCompleteSubtitle() {
        return questCompleteSubtitle;
    }

    @Generated
    public static boolean isUseQuestLeaveTitles() {
        return useQuestLeaveTitles;
    }

    @Generated
    public static String getQuestLeaveTitle() {
        return questLeaveTitle;
    }

    @Generated
    public static String getQuestLeaveSubtitle() {
        return questLeaveSubtitle;
    }

    @Generated
    public static boolean isDoQuestChatProgression() {
        return doQuestChatProgression;
    }

    @Generated
    public static String getOngoingColorCode() {
        return ongoingColorCode;
    }

    @Generated
    public static String getCompletedColorCode() {
        return completedColorCode;
    }

    @Generated
    public static String getKillQuestChatProgressionMessage() {
        return killQuestChatProgressionMessage;
    }

    @Generated
    public static String getFetchQuestChatProgressionMessage() {
        return fetchQuestChatProgressionMessage;
    }

    @Generated
    public static String getDialogQuestChatProgressionMessage() {
        return dialogQuestChatProgressionMessage;
    }

    @Generated
    public static boolean isUseQuestScoreboards() {
        return useQuestScoreboards;
    }

    @Generated
    public static String getKillQuestScoreboardProgressionLine() {
        return killQuestScoreboardProgressionLine;
    }

    @Generated
    public static String getFetchQuestScoreboardProgressionLine() {
        return fetchQuestScoreboardProgressionLine;
    }

    @Generated
    public static String getDialogQuestScoreboardProgressionLine() {
        return dialogQuestScoreboardProgressionLine;
    }

    @Generated
    public static int getMaximumActiveQuests() {
        return maximumActiveQuests;
    }

    @Generated
    public static String getQuestCapMessage() {
        return questCapMessage;
    }

    @Generated
    public static List<EntityType> getQuestEntityTypes() {
        return questEntityTypes;
    }

    @Generated
    public static String getChatTrackMessage() {
        return chatTrackMessage;
    }

    @Generated
    public static String getChatTrackHover() {
        return chatTrackHover;
    }

    @Generated
    public static String getChatTrackCommand() {
        return chatTrackCommand;
    }

    @Generated
    public static String getChatTrackingMessage() {
        return chatTrackingMessage;
    }

    @Generated
    public static String getChatTrackingHover() {
        return chatTrackingHover;
    }

    @Generated
    public static String getChatTrackingCommand() {
        return chatTrackingCommand;
    }

    @Generated
    public static boolean isAutoTrackQuestsOnAccept() {
        return autoTrackQuestsOnAccept;
    }

    @Generated
    public static String getNoQuestDestinationFound() {
        return noQuestDestinationFound;
    }

    @Generated
    public static String getQuestDestinationInOtherWorld() {
        return questDestinationInOtherWorld;
    }

    @Generated
    public static String getQuestAlreadyCompletedMessage() {
        return questAlreadyCompletedMessage;
    }

    @Generated
    public static String getQuestPrerequisitesMissingMessage() {
        return questPrerequisitesMissingMessage;
    }

    @Generated
    public static String getLowRankDynamicQuestWarning() {
        return lowRankDynamicQuestWarning;
    }

    @Generated
    public static String getQuestTurnInObjective() {
        return questTurnInObjective;
    }

    @Generated
    public static int getHorizontalCharacterLimitBedrockMenu() {
        return horizontalCharacterLimitBedrockMenu;
    }

    @Generated
    public static int getItemEntryCharacterLimitBedrockMenu() {
        return itemEntryCharacterLimitBedrockMenu;
    }

    static {
        questEntityTypes = new ArrayList<EntityType>();
    }
}

