/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.magmacore.menus.ContentPackage;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class MetaPackage
extends EMPackage {
    public MetaPackage(ContentPackagesConfigFields contentPackagesConfigFields) {
        super(contentPackagesConfigFields);
    }

    public List<EMPackage> getPackages() {
        ArrayList<EMPackage> packages = new ArrayList<EMPackage>();
        for (String packageFilename : this.contentPackagesConfigFields.getContainedPackages()) {
            EMPackage emPackage = EMPackage.getEmPackages().get(packageFilename);
            if (emPackage == null) continue;
            packages.add(emPackage);
        }
        return packages;
    }

    @Override
    protected ContentPackage.ContentState getContentState() {
        boolean allInstalled = true;
        boolean someInstalled = false;
        boolean allDownloaded = true;
        for (EMPackage aPackage : this.getPackages()) {
            if (!aPackage.isInstalled()) {
                allInstalled = false;
            }
            if (aPackage.isInstalled()) {
                someInstalled = true;
            }
            if (aPackage.isDownloaded()) continue;
            allDownloaded = false;
        }
        if (allInstalled) {
            this.isInstalled = true;
            return ContentPackage.ContentState.INSTALLED;
        }
        if (someInstalled) {
            this.isInstalled = true;
            return ContentPackage.ContentState.PARTIALLY_INSTALLED;
        }
        if (allDownloaded) {
            this.isDownloaded = true;
            return ContentPackage.ContentState.NOT_INSTALLED;
        }
        return ContentPackage.ContentState.NOT_DOWNLOADED;
    }

    @Override
    public void doInstall(Player player) {
        player.closeInventory();
        this.getPackages().forEach(emPackage -> emPackage.doInstall(player));
        this.isInstalled = true;
    }

    @Override
    public void doUninstall(Player player) {
        player.closeInventory();
        this.getPackages().forEach(emPackage -> emPackage.doUninstall(player));
        this.isInstalled = false;
    }

    @Override
    public void baseInitialization() {
    }

    @Override
    public void initializeContent() {
    }
}

