/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items;

import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.enchantments.EnchantmentsConfig;
import com.magmaguy.elitemobs.config.potioneffects.PotionEffectsConfig;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.ItemWorthCalculator;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffect;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffectContainer;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Round;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EliteItemLore {
    private final List<String> vanillaEnchantmentsLore = new ArrayList<String>();
    private final HashMap<Enchantment, Integer> eliteVanillaEnchantments = new HashMap();
    private final ArrayList<String> eliteVanillaEnchantmentsLore = new ArrayList();
    private final HashMap<CustomEnchantment, Integer> customEnchantments = new HashMap();
    private final ArrayList<String> customEnchantmentLore = new ArrayList();
    private final List<String> potionListLore = new ArrayList<String>();
    private ItemStack itemStack;
    private ItemMeta itemMeta;
    private List<String> lore;
    private String soulbindInfo = null;
    private boolean showItemWorth;
    private String itemWorth = null;
    private String itemSource = null;
    private EliteEntity eliteEntity;
    private Player soulboundPlayer = null;
    private List<String> customLore = new ArrayList<String>();
    private int prestigeLevel = 0;
    private int enchantmentCount = 0;
    private List<String> thirdPartyLore = null;

    public EliteItemLore(ItemStack itemStack, boolean showItemWorth) {
        this.initialize(itemStack, showItemWorth);
    }

    public EliteItemLore(ItemStack itemStack, boolean showItemWorth, boolean isNewItem) {
        if (isNewItem && itemStack.hasItemMeta() && itemStack.getItemMeta().hasLore() && itemStack.getItemMeta().getLore() != null && !itemStack.getItemMeta().getLore().isEmpty()) {
            this.thirdPartyLore = itemStack.getItemMeta().getLore();
        }
        this.initialize(itemStack, showItemWorth);
    }

    private void initialize(ItemStack itemStack, boolean showItemWorth) {
        if (!EliteItemManager.isEliteMobsItem(itemStack)) {
            return;
        }
        this.itemStack = itemStack;
        this.itemMeta = itemStack.getItemMeta();
        this.lore = new ArrayList<String>();
        this.showItemWorth = showItemWorth;
        if (ItemSettingsConfig.isHideAttributes()) {
            this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        this.constructVanillaEnchantments();
        this.parseAllEliteEnchantments();
        this.constructEliteEnchantments();
        this.parseCustomEnchantments();
        this.constructCustomEnchantments();
        this.constructSoulbindEntry();
        this.constructSoulboundOwner();
        this.constructItemSource();
        this.constructCustomLore();
        this.constructPrestigeLevel();
        this.constructPotionEffects();
        this.constructItemWorth();
        this.writeNewLore();
        this.itemMeta.setLore(this.lore);
        ItemTagger.registerEnchantmentCount(this.itemMeta, this.enchantmentCount);
        this.itemStack.setItemMeta(this.itemMeta);
    }

    private void constructVanillaEnchantments() {
        for (Enchantment enchantment : this.itemMeta.getEnchants().keySet()) {
            if (enchantment.getName().contains("CURSE")) {
                this.vanillaEnchantmentsLore.add(ChatColorConverter.convert("&c" + EnchantmentsConfig.getEnchantment(enchantment).getName() + " " + this.itemMeta.getEnchants().get(enchantment)));
            } else {
                this.vanillaEnchantmentsLore.add(ChatColorConverter.convert("&7" + EnchantmentsConfig.getEnchantment(enchantment).getName() + " " + this.itemMeta.getEnchants().get(enchantment)));
            }
            this.enchantmentCount += this.itemMeta.getEnchantLevel(enchantment);
        }
    }

    private void parseAllEliteEnchantments() {
        this.parseEliteEnchantments(Enchantment.SHARPNESS);
        this.parseEliteEnchantments(Enchantment.POWER);
        this.parseEliteEnchantments(Enchantment.PROTECTION);
        this.parseEliteEnchantments(Enchantment.BANE_OF_ARTHROPODS);
        this.parseEliteEnchantments(Enchantment.SMITE);
        this.parseEliteEnchantments(Enchantment.BLAST_PROTECTION);
        this.parseEliteEnchantments(Enchantment.FIRE_PROTECTION);
        this.parseEliteEnchantments(Enchantment.PROJECTILE_PROTECTION);
        this.parseEliteEnchantments(Enchantment.THORNS);
    }

    private void parseEliteEnchantments(Enchantment enchantment) {
        int enchantmentLevel = ItemTagger.getEnchantment(this.itemMeta, enchantment.getKey());
        if (enchantmentLevel > enchantment.getMaxLevel()) {
            int eliteLevel = enchantmentLevel - enchantment.getMaxLevel();
            this.eliteVanillaEnchantments.put(enchantment, eliteLevel);
            this.enchantmentCount += eliteLevel;
        }
    }

    private void constructEliteEnchantments() {
        for (Enchantment enchantment : this.eliteVanillaEnchantments.keySet()) {
            this.eliteVanillaEnchantmentsLore.add(ChatColorConverter.convert("&7" + ItemSettingsConfig.getEliteEnchantLoreString() + " " + EnchantmentsConfig.getEnchantment(enchantment).getName() + " " + this.eliteVanillaEnchantments.get(enchantment)));
        }
    }

    private void parseCustomEnchantments() {
        for (CustomEnchantment customEnchantment : CustomEnchantment.getCustomEnchantmentMap().values()) {
            int enchantmentLevel = ItemTagger.getEnchantment(this.itemMeta, customEnchantment.getKey());
            if (enchantmentLevel <= 0) continue;
            this.customEnchantments.put(customEnchantment, enchantmentLevel);
            this.enchantmentCount += enchantmentLevel;
        }
    }

    private void constructCustomEnchantments() {
        for (CustomEnchantment customEnchantment : this.customEnchantments.keySet()) {
            this.customEnchantmentLore.add(ChatColorConverter.convert("&6" + customEnchantment.getEnchantmentsConfigFields().getName() + " " + this.customEnchantments.get(customEnchantment)));
        }
    }

    private void constructSoulbindEntry() {
        Player player = SoulbindEnchantment.getSoulboundPlayer(this.itemMeta);
        if (player == null) {
            this.soulbindInfo = ChatColorConverter.convert(ItemSettingsConfig.getNoSoulbindLore());
            return;
        }
        this.soulbindInfo = ChatColorConverter.convert(EnchantmentsConfig.getEnchantment("soulbind.yml").getFileConfiguration().getString("loreStrings").replace("$player", player.getDisplayName()));
    }

    private void constructPrestigeLevel() {
        this.prestigeLevel = SoulbindEnchantment.getPrestigeLevel(this.itemMeta);
    }

    private void constructItemWorth() {
        this.itemStack.setItemMeta(this.itemMeta);
        ItemTagger.writeItemValue(this.itemStack, this.soulboundPlayer);
        this.itemMeta = this.itemStack.getItemMeta();
        this.itemWorth = this.showItemWorth ? ItemSettingsConfig.getLoreWorth().replace("$worth", "" + ItemWorthCalculator.determineItemWorth(this.itemStack, this.soulboundPlayer)).replace("$currencyName", EconomySettingsConfig.getCurrencyName()) : ItemSettingsConfig.getLoreResale().replace("$resale", "" + ItemWorthCalculator.determineResaleWorth(this.itemStack, this.soulboundPlayer)).replace("$currencyName", EconomySettingsConfig.getCurrencyName());
    }

    private void constructSoulboundOwner() {
        this.soulboundPlayer = SoulbindEnchantment.getSoulboundPlayer(this.itemMeta);
    }

    private void constructItemSource() {
        this.itemSource = ItemTagger.getItemSource(this.itemMeta);
    }

    private void constructCustomLore() {
        this.customLore = ItemTagger.getCustomLore(this.itemMeta);
    }

    private void constructPotionEffects() {
        for (ElitePotionEffect elitePotionEffect : ElitePotionEffectContainer.getElitePotionEffectContainer(this.itemMeta, ItemTagger.continuousPotionEffectKey)) {
            this.potionListLore.add(ChatColorConverter.convert(PotionEffectsConfig.getPotionEffect(elitePotionEffect.getPotionEffect().getType().getKey().getKey().toLowerCase(Locale.ROOT) + ".yml").getName() + ItemSettingsConfig.getPotionEffectContinuousLore() + " " + (elitePotionEffect.getPotionEffect().getAmplifier() + 1)));
        }
        for (ElitePotionEffect elitePotionEffect : ElitePotionEffectContainer.getElitePotionEffectContainer(this.itemMeta, ItemTagger.onHitPotionEffectKey)) {
            if (elitePotionEffect.getTarget().equals((Object)ElitePotionEffect.Target.SELF)) {
                this.potionListLore.add(ChatColorConverter.convert(PotionEffectsConfig.getPotionEffect(elitePotionEffect.getPotionEffect().getType().getKey().getKey().toLowerCase(Locale.ROOT) + ".yml").getName() + ItemSettingsConfig.getPotionEffectOnHitSelfLore() + " " + (elitePotionEffect.getPotionEffect().getAmplifier() + 1)));
                continue;
            }
            this.potionListLore.add(ChatColorConverter.convert(PotionEffectsConfig.getPotionEffect(elitePotionEffect.getPotionEffect().getType().getKey().getKey().toLowerCase(Locale.ROOT) + ".yml").getName() + ItemSettingsConfig.getPotionEffectOnHitTargetLore() + " " + (elitePotionEffect.getPotionEffect().getAmplifier() + 1)));
        }
    }

    private void writeNewLore() {
        if (this.thirdPartyLore != null) {
            this.lore.addAll(this.thirdPartyLore);
        }
        for (String string : ItemSettingsConfig.getLoreStructure()) {
            if (string.contains("$weaponOrArmorStats")) {
                string = EliteItemManager.isWeapon(this.itemStack) ? ItemSettingsConfig.getWeaponEntry() : (EliteItemManager.isArmor(this.itemStack) ? ItemSettingsConfig.getArmorEntry() : "");
            }
            string = this.stringReplacer(string, "$EDPS", Round.twoDecimalPlaces(EliteItemManager.getDPS(this.itemStack)));
            string = this.stringReplacer(string, "$EDEF", Round.twoDecimalPlaces(EliteItemManager.getEliteDefense(this.itemStack) + EliteItemManager.getBonusEliteDefense(this.itemStack)));
            string = this.stringReplacer(string, "$prestigeLevel", this.prestigeLevel);
            if ((string = this.stringReplacer(string, "$itemLevel", EliteItemManager.getRoundedItemLevel(this.itemStack))).contains("$enchantments")) {
                for (String entry : this.vanillaEnchantmentsLore) {
                    this.lore.add(ChatColorConverter.convert(ItemSettingsConfig.getVanillaEnchantmentColor() + entry));
                }
                continue;
            }
            if (string.contains("$eliteEnchantments")) {
                for (String entry : this.eliteVanillaEnchantmentsLore) {
                    this.lore.add(ChatColorConverter.convert(ItemSettingsConfig.getEliteEnchantmentColor() + ChatColor.stripColor((String)entry)));
                }
                continue;
            }
            if (string.contains("$itemSource")) {
                if (this.itemSource == null) continue;
                this.lore.add(this.itemSource);
                continue;
            }
            if (string.contains("$potionEffect")) {
                for (String entry : this.potionListLore) {
                    this.lore.add(ChatColorConverter.convert(ItemSettingsConfig.getPotionEffectColor() + entry));
                }
                continue;
            }
            if (string.contains("$customEnchantments")) {
                for (String entry : this.customEnchantmentLore) {
                    this.lore.add(ChatColorConverter.convert(ItemSettingsConfig.getCustomEnchantmentColor() + ChatColor.stripColor((String)entry)));
                }
                continue;
            }
            if (string.contains("$loreResaleValue")) {
                this.lore.add(this.itemWorth);
                continue;
            }
            if (string.contains("$customLore")) {
                for (String entry : this.customLore) {
                    this.lore.add(ChatColorConverter.convert(entry));
                }
                continue;
            }
            if (string.contains("$soulbindInfo")) {
                this.lore.add(this.soulbindInfo);
                continue;
            }
            if (string.contains("$ifPotionEffects")) {
                if (this.potionListLore.isEmpty()) continue;
                this.lore.add(string.replace("$ifPotionEffects", ""));
                continue;
            }
            if (string.contains("$ifEnchantments")) {
                if (this.vanillaEnchantmentsLore.isEmpty()) continue;
                this.lore.add(string.replace("$ifEnchantments", ""));
                continue;
            }
            if (string.contains("$ifLore")) {
                if (this.customLore.isEmpty()) continue;
                this.lore.add(string.replace("$ifLore", ""));
                continue;
            }
            if (string.contains("$ifCustomEnchantments")) {
                if (this.customEnchantments.isEmpty()) continue;
                this.lore.add(string.replace("$ifCustomEnchantments", ""));
                continue;
            }
            if (string.isEmpty()) continue;
            this.lore.add(ChatColorConverter.convert(string));
        }
    }

    private String stringReplacer(String originalString, String placeholder, int value) {
        return this.stringReplacer(originalString, placeholder, "" + value);
    }

    private String stringReplacer(String originalString, String placeholder, double value) {
        return this.stringReplacer(originalString, placeholder, "" + value);
    }

    private String stringReplacer(String originalString, String placeholder, String replacement) {
        String processedString = originalString;
        if (originalString.contains(placeholder)) {
            processedString = originalString.replace(placeholder, replacement);
        }
        return processedString;
    }

    @Generated
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

