/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.utils.CustomModelAdder;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EliteScroll {
    public static final NamespacedKey eliteScrollNamespacedKey = new NamespacedKey((Plugin)MetadataHandler.PLUGIN, "elite_scroll");
    public static Material scrollMaterial = Material.PAPER;

    private EliteScroll() {
    }

    public static ItemStack generateScroll(int scrollLevel, Player player) {
        ItemStack itemStack = ItemStackGenerator.generateItemStack(scrollMaterial, ItemSettingsConfig.getEliteItemScrollName());
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        itemMeta.getPersistentDataContainer().set(eliteScrollNamespacedKey, PersistentDataType.INTEGER, (Object)scrollLevel);
        CustomModelAdder.addCustomModel(itemMeta, ItemSettingsConfig.getEliteItemModel());
        itemStack.setItemMeta(itemMeta);
        ItemTagger.registerEliteItem(itemStack);
        SoulbindEnchantment.addEnchantment(itemStack, player);
        itemMeta = itemStack.getItemMeta();
        List existingLore = itemMeta.hasLore() ? itemMeta.getLore() : new ArrayList();
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : ItemSettingsConfig.getEliteItemScrollLore()) {
            lore.add(ChatColorConverter.convert(line.replace("$level", String.valueOf(scrollLevel))));
        }
        lore.addAll(existingLore);
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static boolean isEliteScroll(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        return itemStack.getItemMeta().getPersistentDataContainer().has(eliteScrollNamespacedKey);
    }

    public static int getEliteScrollLevel(ItemStack itemStack) {
        if (!EliteScroll.isEliteScroll(itemStack)) {
            return 0;
        }
        return (Integer)itemStack.getItemMeta().getPersistentDataContainer().get(eliteScrollNamespacedKey, PersistentDataType.INTEGER);
    }

    public static ItemStack convertVanillaItem(ItemStack originalItem, ItemStack scrollItemStack) {
        Player player = SoulbindEnchantment.getSoulboundPlayer(scrollItemStack.getItemMeta());
        ItemStack newItem = originalItem.clone();
        ItemTagger.registerEliteItem(newItem);
        EliteItemManager.setEliteLevel(newItem, EliteScroll.getEliteScrollLevel(scrollItemStack), true);
        if (player != null) {
            SoulbindEnchantment.addEnchantment(newItem, player);
        }
        return newItem;
    }
}

