/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GrapplingHookEnchantment
extends CustomEnchantment {
    public static String key = "grappling_hook";

    public GrapplingHookEnchantment() {
        super(key, false);
    }

    public static boolean isGrapplingHookProjectile(ItemMeta itemMeta) {
        return ItemTagger.getEnchantment(itemMeta, key) > 0;
    }

    public static void trackGrapplingHook(final AbstractArrow arrow, final Player player) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (this.counter > 200 || arrow.isInBlock()) {
                    Location targetBlock;
                    if (arrow.getAttachedBlock() != null && (targetBlock = GrapplingHookEnchantment.getTargetBlock(arrow.getLocation())) != null) {
                        GrapplingHookEnchantment.zipline(player, arrow.getAttachedBlock().getRelative(arrow.getFacing()).getLocation().add(new Vector(0.5, 0.5, 0.5)));
                        arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                    }
                    this.cancel();
                    return;
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
    }

    private static void zipline(final Player player, final Location location) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 200, 1));
        new BukkitRunnable(){
            int timer = 0;

            public void run() {
                if (this.timer > 200 || player.getLocation().distance(location) < 1.0) {
                    player.setGravity(true);
                    player.removePotionEffect(PotionEffectType.LEVITATION);
                    player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 60, 1));
                    this.cancel();
                    return;
                }
                player.setVelocity(location.clone().subtract(player.getLocation()).toVector().normalize().multiply(0.5));
                ++this.timer;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
    }

    private static Location getTargetBlock(Location airLocation) {
        if (GrapplingHookEnchantment.checkBlock(airLocation)) {
            return airLocation;
        }
        Location up = airLocation.clone().add(new Vector(0, 1, 0));
        if (GrapplingHookEnchantment.checkBlock(up)) {
            return up;
        }
        Location down = airLocation.clone().add(new Vector(0, -1, 0));
        if (GrapplingHookEnchantment.checkBlock(down)) {
            return down;
        }
        Location front = airLocation.clone().add(new Vector(1, 0, 0));
        if (GrapplingHookEnchantment.checkBlock(front)) {
            return front;
        }
        Location back = airLocation.clone().add(new Vector(-1, 0, 0));
        if (GrapplingHookEnchantment.checkBlock(back)) {
            return back;
        }
        Location left = airLocation.clone().add(new Vector(0, 0, 1));
        if (GrapplingHookEnchantment.checkBlock(left)) {
            return left;
        }
        Location right = airLocation.clone().add(new Vector(0, 0, -1));
        if (GrapplingHookEnchantment.checkBlock(right)) {
            return right;
        }
        return null;
    }

    private static boolean checkBlock(Location location) {
        return location.getBlock().getType().equals((Object)Material.TARGET);
    }

    public static class GrapplingHookEnchantmentEvents
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onArrowFire(EntityShootBowEvent event) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            if (!event.getProjectile().getType().equals((Object)EntityType.ARROW) && !event.getProjectile().getType().equals((Object)EntityType.SPECTRAL_ARROW)) {
                return;
            }
            if (event.getConsumable() == null || !GrapplingHookEnchantment.isGrapplingHookProjectile(event.getConsumable().getItemMeta())) {
                return;
            }
            ((AbstractArrow)event.getProjectile()).setBounce(false);
            event.getEntity().setLeashHolder((Entity)event.getEntity());
            GrapplingHookEnchantment.trackGrapplingHook((AbstractArrow)event.getProjectile(), (Player)event.getEntity());
        }
    }
}

