/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customloottable;

import com.magmaguy.elitemobs.items.customloottable.CustomLootEntry;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandLootTable
extends CustomLootEntry
implements Serializable {
    private String command = null;

    public CommandLootTable(List<CustomLootEntry> entries, String rawString, String configFilename) {
        this.parseNewFormat(rawString, configFilename);
        entries.add(this);
    }

    private void parseNewFormat(String rawString, String configFilename) {
        block24: for (String string : rawString.split(":")) {
            String[] strings = string.split("=");
            switch (strings[0].toLowerCase(Locale.ROOT)) {
                case "command": {
                    try {
                        this.command = strings[1];
                    }
                    catch (Exception ex) {
                        CommandLootTable.errorMessage(rawString, configFilename, "filename");
                    }
                    continue block24;
                }
                case "amount": {
                    try {
                        super.setAmount(Integer.parseInt(strings[1]));
                    }
                    catch (Exception ex) {
                        CommandLootTable.errorMessage(rawString, configFilename, "amount");
                    }
                    continue block24;
                }
                case "chance": {
                    try {
                        super.setChance(Double.parseDouble(strings[1]));
                    }
                    catch (Exception ex) {
                        CommandLootTable.errorMessage(rawString, configFilename, "chance");
                    }
                    continue block24;
                }
                case "permission": {
                    try {
                        super.setPermission(strings[1]);
                    }
                    catch (Exception ex) {
                        CommandLootTable.errorMessage(rawString, configFilename, "permission");
                    }
                    continue block24;
                }
                case "wave": {
                    try {
                        super.setWave(Integer.parseInt(strings[1]));
                    }
                    catch (Exception ex) {
                        CommandLootTable.errorMessage(rawString, configFilename, "wave");
                    }
                    continue block24;
                }
            }
        }
    }

    @Override
    public void locationDrop(int itemTier, Player player, Location location) {
        if (!this.getPermission().isEmpty() && !player.hasPermission(this.getPermission())) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() < this.getChance()) {
            return;
        }
        for (int i = 0; i < this.getAmount(); ++i) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.command.replace("%player%", player.getName()));
        }
    }

    @Override
    public void directDrop(int itemTier, Player player) {
        if (!this.getPermission().isEmpty() && !player.hasPermission(this.getPermission())) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() < this.getChance()) {
            return;
        }
        for (int i = 0; i < this.getAmount(); ++i) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.command.replace("%player%", player.getName()));
        }
    }

    @Generated
    public String getCommand() {
        return this.command;
    }
}

