/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customloottable;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.customarenas.CustomArenasConfigFields;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.config.customquests.CustomQuestsConfigFields;
import com.magmaguy.elitemobs.config.customtreasurechests.CustomTreasureChestConfigFields;
import com.magmaguy.elitemobs.items.customloottable.CommandLootTable;
import com.magmaguy.elitemobs.items.customloottable.CurrencyCustomLootEntry;
import com.magmaguy.elitemobs.items.customloottable.CustomLootEntry;
import com.magmaguy.elitemobs.items.customloottable.EliteCustomLootEntry;
import com.magmaguy.elitemobs.items.customloottable.ItemStackCustomLootEntry;
import com.magmaguy.elitemobs.items.customloottable.VanillaCustomLootEntry;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CustomLootTable
implements Serializable {
    private final List<CustomLootEntry> entries = new ArrayList<CustomLootEntry>();
    private final Map<Integer, List<CustomLootEntry>> waveRewards = new HashMap<Integer, List<CustomLootEntry>>();

    public CustomLootTable() {
    }

    public CustomLootTable(CustomBossesConfigFields customBossesConfigFields) {
        List<Object> rawStrings = customBossesConfigFields.getUniqueLootList();
        this.parseConfig(rawStrings, customBossesConfigFields.getFilename());
    }

    public CustomLootTable(CustomTreasureChestConfigFields treasureChestConfigFields) {
        List<Object> rawStrings = treasureChestConfigFields.getLootList();
        this.parseConfig(rawStrings, treasureChestConfigFields.getFilename());
    }

    public CustomLootTable(CustomQuestsConfigFields questsConfigFields) {
        List<String> rawStrings = questsConfigFields.getCustomRewardsList();
        this.parseConfig(rawStrings, questsConfigFields.getFilename());
    }

    public CustomLootTable(CustomArenasConfigFields customArenasConfigFields) {
        List<Object> rawStrings = customArenasConfigFields.getRawArenaRewards();
        this.parseConfig(rawStrings, customArenasConfigFields.getFilename());
    }

    private void parseConfig(List<?> lootTable, String filename) {
        if (lootTable == null) {
            return;
        }
        for (Object object : lootTable) {
            if (object instanceof String) {
                String rawString = (String)object;
                switch (rawString.split(":")[0].toLowerCase(Locale.ROOT)) {
                    case "minecraft": {
                        new VanillaCustomLootEntry(this.entries, rawString, filename);
                        break;
                    }
                    default: {
                        if (rawString.toLowerCase(Locale.ROOT).contains("currencyamount=")) {
                            new CurrencyCustomLootEntry(this.entries, rawString, filename);
                            break;
                        }
                        if (rawString.contains("material=")) {
                            new VanillaCustomLootEntry(this.entries, rawString, filename);
                            break;
                        }
                        if (rawString.contains("command=")) {
                            new CommandLootTable(this.entries, rawString, filename);
                            break;
                        }
                        new EliteCustomLootEntry(this.entries, rawString, filename);
                        break;
                    }
                }
                continue;
            }
            if (!(object instanceof Map)) continue;
            Map configMap = (Map)object;
            if (((Map)object).containsKey("currencyAmount") || ((Map)object).containsKey("currencyamount")) {
                new CurrencyCustomLootEntry(this.entries, configMap, filename);
                continue;
            }
            if (((Map)object).containsKey("material")) {
                new VanillaCustomLootEntry(this.entries, configMap, filename);
                continue;
            }
            new EliteCustomLootEntry(this.entries, configMap, filename);
        }
        for (CustomLootEntry customLootEntry : this.entries) {
            if (customLootEntry.getWave() <= 0) continue;
            if (this.waveRewards.get(customLootEntry.getWave()) != null) {
                List<CustomLootEntry> rewards = this.waveRewards.get(customLootEntry.getWave());
                rewards.add(customLootEntry);
                this.waveRewards.put(customLootEntry.getWave(), rewards);
                continue;
            }
            this.waveRewards.put(customLootEntry.getWave(), new ArrayList<CustomLootEntry>(List.of(customLootEntry)));
        }
    }

    public void generateCurrencyEntry(int currencyAmount) {
        new CurrencyCustomLootEntry(this.entries, currencyAmount);
    }

    public void generateEliteEntry(ItemStack itemStack) {
        new ItemStackCustomLootEntry(this.entries, itemStack);
    }

    public void bossDrop(Player player, int level, Location dropLocation, EliteEntity eliteEntity) {
        for (CustomLootEntry customLootEntry : this.entries) {
            if (!customLootEntry.willDrop(player)) continue;
            if (ItemSettingsConfig.isPutLootDirectlyIntoPlayerInventory()) {
                customLootEntry.directDrop(level, player, eliteEntity);
                continue;
            }
            customLootEntry.locationDrop(level, player, dropLocation, eliteEntity);
        }
    }

    public void treasureChestDrop(Player player, int chestLevel, Location dropLocation) {
        boolean anythingDropped = false;
        for (CustomLootEntry customLootEntry : this.entries) {
            if (!customLootEntry.willDrop(player)) continue;
            anythingDropped = true;
            if (ItemSettingsConfig.isPutLootDirectlyIntoPlayerInventory()) {
                customLootEntry.directDrop(chestLevel * 10, player);
                continue;
            }
            customLootEntry.locationDrop(chestLevel * 10, player, dropLocation);
        }
        if (!anythingDropped) {
            player.sendMessage(ChatColorConverter.convert(DefaultConfig.getTreasureChestNoDropMessage()));
        }
    }

    public void questDrop(Player player, int questRewardLevel) {
        for (CustomLootEntry customLootEntry : this.entries) {
            if (!customLootEntry.willDrop(player)) continue;
            customLootEntry.directDrop(questRewardLevel, player);
        }
    }

    public void arenaReward(Player player, int wave) {
        if (this.waveRewards.get(wave) == null) {
            return;
        }
        this.waveRewards.get(wave).forEach(reward -> {
            if (reward.willDrop(player)) {
                reward.directDrop(reward.getItemLevel(), player);
            }
        });
    }

    @Generated
    public List<CustomLootEntry> getEntries() {
        return this.entries;
    }
}

