/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customloottable;

import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.items.customloottable.CustomLootEntry;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class VanillaCustomLootEntry
extends CustomLootEntry
implements Serializable {
    private Material material = null;

    public VanillaCustomLootEntry(List<CustomLootEntry> entries, String rawString, String configFilename) {
        this.parseAllFormats(rawString, configFilename);
        if (this.material == null) {
            return;
        }
        entries.add(this);
    }

    public VanillaCustomLootEntry(List<CustomLootEntry> entries, Map<String, Object> configMap, String configFilename) {
        this.parseAllFormats(configMap, configFilename);
        if (this.material == null) {
            return;
        }
        entries.add(this);
    }

    private void parseAllFormats(Map<String, Object> configMap, String configFilename) {
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            String key = entry.getKey().toLowerCase(Locale.ROOT);
            String value = entry.getValue().toString();
            switch (key) {
                case "type": 
                case "material": {
                    try {
                        this.material = Material.valueOf((String)value.toUpperCase());
                    }
                    catch (Exception ex) {
                        VanillaCustomLootEntry.errorMessage(value, configFilename, "material");
                    }
                    break;
                }
                case "amount": {
                    try {
                        super.setAmount(Integer.parseInt(value));
                    }
                    catch (Exception ex) {
                        VanillaCustomLootEntry.errorMessage(value, configFilename, "amount");
                    }
                    break;
                }
                case "chance": {
                    try {
                        super.setChance(Double.parseDouble(value));
                    }
                    catch (Exception ex) {
                        VanillaCustomLootEntry.errorMessage(value, configFilename, "chance");
                    }
                    break;
                }
                case "wave": {
                    try {
                        super.setWave(Integer.parseInt(value));
                        break;
                    }
                    catch (Exception ex) {
                        VanillaCustomLootEntry.errorMessage(value, configFilename, "wave");
                    }
                }
            }
        }
    }

    private void parseAllFormats(String rawString, String configFilename) {
        block21: for (String processedString : rawString.split(":")) {
            String[] strings = processedString.split("=");
            switch (strings[0].toLowerCase(Locale.ROOT)) {
                case "type": 
                case "material": {
                    try {
                        this.material = Material.valueOf((String)strings[1]);
                    }
                    catch (Exception ex) {
                        VanillaCustomLootEntry.errorMessage(rawString, configFilename, "material");
                    }
                    continue block21;
                }
                case "amount": {
                    try {
                        super.setAmount(Integer.parseInt(strings[1]));
                    }
                    catch (Exception ex) {
                        VanillaCustomLootEntry.errorMessage(rawString, configFilename, "amount");
                    }
                    continue block21;
                }
                case "chance": {
                    try {
                        super.setChance(Double.parseDouble(strings[1]));
                    }
                    catch (Exception ex) {
                        VanillaCustomLootEntry.errorMessage(rawString, configFilename, "chance");
                    }
                    continue block21;
                }
                case "wave": {
                    try {
                        super.setWave(Integer.parseInt(strings[1]));
                        continue block21;
                    }
                    catch (Exception ex) {
                        VanillaCustomLootEntry.errorMessage(rawString, configFilename, "wave");
                    }
                }
            }
        }
    }

    public ItemStack generateItemStack() {
        return new ItemStack(this.material, 1);
    }

    @Override
    public void locationDrop(int itemTier, Player player, Location location) {
        for (int i = 0; i < this.getAmount(); ++i) {
            location.getWorld().dropItem(location, this.generateItemStack());
        }
    }

    @Override
    public void locationDrop(int itemTier, Player player, Location location, EliteEntity eliteEntity) {
        for (int i = 0; i < this.getAmount(); ++i) {
            location.getWorld().dropItem(location, this.generateItemStack());
        }
    }

    @Override
    public void directDrop(int itemTier, Player player) {
        String name = null;
        for (int i = 0; i < this.getAmount(); ++i) {
            if (ThreadLocalRandom.current().nextDouble() > this.getChance()) {
                return;
            }
            ItemStack itemStack = this.generateItemStack();
            player.getInventory().addItem(new ItemStack[]{itemStack});
            if (name != null || itemStack.getItemMeta() == null) continue;
            name = itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : itemStack.getType().toString().replace("_", " ");
        }
        if (name != null) {
            player.sendMessage(ItemSettingsConfig.getDirectDropMinecraftLootMessage().replace("$itemName", this.getAmount() + "x " + name));
        }
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }
}

