/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.itemconstructor;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.items.EliteItemLore;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.items.itemconstructor.EnchantmentGenerator;
import com.magmaguy.elitemobs.items.itemconstructor.ItemQualityColorizer;
import com.magmaguy.elitemobs.items.itemconstructor.MaterialGenerator;
import com.magmaguy.elitemobs.items.itemconstructor.NameGenerator;
import com.magmaguy.elitemobs.items.potioneffects.ElitePotionEffectContainer;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.utils.CustomModelAdder;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemConstructor {
    public static ItemStack constructItem(int level, String rawName, Material material, HashMap<Enchantment, Integer> enchantments, HashMap<String, Integer> customEnchantments, List<String> potionEffects, List<String> lore, EliteEntity eliteEntity, Player player, boolean showItemWorth, String customModelID, boolean soulbound, String filename) {
        ItemStack itemStack = ItemStackGenerator.generateItemStack(material);
        if (level != -1) {
            EliteItemManager.setEliteLevel(itemStack, level);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColorConverter.convert(rawName));
        if (!enchantments.isEmpty()) {
            EnchantmentGenerator.generateEnchantments(itemMeta, enchantments);
        }
        itemStack.setItemMeta(itemMeta);
        if (lore != null && !lore.isEmpty()) {
            ItemTagger.registerCustomLore(itemMeta, lore);
        }
        new ElitePotionEffectContainer(itemMeta, potionEffects);
        itemStack.setItemMeta(itemMeta);
        itemStack = CustomModelAdder.addCustomModel(itemStack, customModelID);
        itemMeta = itemStack.getItemMeta();
        Objects.requireNonNull(itemMeta).getPersistentDataContainer().set(new NamespacedKey((Plugin)MetadataHandler.PLUGIN, filename), PersistentDataType.STRING, (Object)filename);
        itemStack.setItemMeta(itemMeta);
        return ItemConstructor.commonFeatures(itemStack, eliteEntity, player, enchantments, customEnchantments, showItemWorth, soulbound);
    }

    public static ItemStack constructItem(double itemTier, EliteEntity killedMob, Player player, boolean showItemWorth) {
        Material itemMaterial = MaterialGenerator.generateMaterial(itemTier);
        if (itemMaterial == null) {
            return null;
        }
        ItemStack itemStack = ItemStackGenerator.generateItemStack(itemMaterial);
        EliteItemManager.setEliteLevel(itemStack, (int)Math.round(itemTier));
        ItemMeta itemMeta = itemStack.getItemMeta();
        HashMap<Enchantment, Integer> enchantmentMap = EnchantmentGenerator.generateEnchantments(itemTier, itemMaterial, itemMeta);
        HashMap<String, Integer> customEnchantmentMap = EnchantmentGenerator.generateCustomEnchantments(itemTier, itemMaterial);
        itemMeta.setDisplayName(NameGenerator.generateName(itemMaterial));
        itemStack.setItemMeta(itemMeta);
        ItemQualityColorizer.dropQualityColorizer(itemStack);
        return ItemConstructor.commonFeatures(itemStack, killedMob, player, enchantmentMap, customEnchantmentMap, showItemWorth, true);
    }

    private static ItemStack commonFeatures(ItemStack itemStack, EliteEntity eliteEntity, Player player, HashMap<Enchantment, Integer> enchantments, HashMap<String, Integer> customEnchantments, boolean showItemWorth, boolean soulbound) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        ItemTagger.registerEliteItem(itemMeta);
        ItemTagger.registerItemSource(eliteEntity, itemMeta);
        ItemTagger.registerEnchantments(itemMeta, enchantments);
        ItemTagger.registerCustomEnchantments(itemMeta, customEnchantments);
        itemStack.setItemMeta(itemMeta);
        if (soulbound) {
            SoulbindEnchantment.addEnchantment(itemStack, player);
        }
        new EliteItemLore(itemStack, showItemWorth);
        return itemStack;
    }
}

