/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobHealEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.collateralminecraftchanges.KeepNeutralsAngry;
import com.magmaguy.elitemobs.combatsystem.antiexploit.AntiExploitMessage;
import com.magmaguy.elitemobs.config.AntiExploitConfig;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.config.powers.PowersConfigFields;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.mobdata.aggressivemobs.EliteMobProperties;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powerstances.MajorPowerPowerStance;
import com.magmaguy.elitemobs.powerstances.MinorPowerPowerStance;
import com.magmaguy.elitemobs.tagger.PersistentTagger;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.AttributeManager;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Goat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class EliteEntity {
    protected final HashMap<Player, Double> damagers = new HashMap();
    protected final UUID eliteUUID = UUID.randomUUID();
    private final HashSet<String> customMetadata = new HashSet();
    protected HashSet<ElitePower> elitePowers = new HashSet();
    protected HashMap<Player, Double> aggro = new HashMap();
    protected LivingEntity livingEntity;
    protected LivingEntity unsyncedLivingEntity;
    protected int level = -1;
    protected double maxHealth;
    protected String name;
    protected int minorPowerCount = 0;
    protected int majorPowerCount = 0;
    protected boolean minorVisualEffect = false;
    protected boolean majorVisualEffect = false;
    protected boolean visualEffectObfuscated = true;
    protected boolean isNaturalEntity;
    protected EntityType entityType;
    protected Boolean isPersistent = false;
    protected boolean vanillaLoot = true;
    protected boolean eliteLoot = true;
    protected boolean randomLoot = true;
    protected CreatureSpawnEvent.SpawnReason spawnReason;
    protected double healthMultiplier = 1.0;
    protected double damageMultiplier = 1.0;
    protected double defaultMaxHealth;
    protected boolean inCooldown = false;
    protected boolean triggeredAntiExploit = false;
    protected int antiExploitPoints = 0;
    protected boolean inAntiExploitCooldown = false;
    protected boolean inCombat = false;
    protected boolean inCombatGracePeriod = false;
    protected EliteEntity summoningEntity;
    protected List<CustomBossEntity> globalReinforcementEntities = new ArrayList<CustomBossEntity>();
    protected List<CustomBossEntity> eliteReinforcementEntities = new ArrayList<CustomBossEntity>();
    protected List<Entity> nonEliteReinforcementEntities = new ArrayList<Entity>();
    protected boolean bypassesProtections = false;
    protected Double health = null;
    protected Location spawnLocation;
    private boolean dying = false;
    private boolean healing = false;
    private final HashMap<NamespacedKey, Object> customData = new HashMap();

    public EliteEntity() {
    }

    public EliteEntity(LivingEntity livingEntity, int level, CreatureSpawnEvent.SpawnReason spawnReason) {
        this.setLevel(level);
        this.setLivingEntity(livingEntity, spawnReason);
        if (spawnReason == CreatureSpawnEvent.SpawnReason.NATURAL) {
            this.isNaturalEntity = true;
        }
        EliteMobProperties eliteMobProperties = EliteMobProperties.getPluginData((Entity)livingEntity);
        this.setName(eliteMobProperties);
        this.setArmor();
        this.setMaxHealth();
        this.randomizePowers(eliteMobProperties);
    }

    public void addCustomData(@NotNull NamespacedKey namespacedKey, Object object) {
        this.customData.put(namespacedKey, object);
    }

    public void removeCustomData(NamespacedKey namespacedKey) {
        this.customData.remove(namespacedKey);
    }

    public boolean hasCustomData(NamespacedKey namespacedKey) {
        return this.customData.containsKey(namespacedKey);
    }

    public Object getCustomData(NamespacedKey namespacedKey) {
        return this.customData.get(namespacedKey);
    }

    public Location getSpawnLocation() {
        return this.spawnLocation.clone();
    }

    public boolean getBypassesProtections() {
        return this.bypassesProtections;
    }

    public void setBypassesProtections(boolean bypassesProtections) {
        this.bypassesProtections = bypassesProtections;
    }

    public UUID getEliteUUID() {
        return this.eliteUUID;
    }

    public void addDamager(Player player, double damage) {
        if (!this.damagers.isEmpty()) {
            for (Player iteratedPlayer : this.damagers.keySet()) {
                if (!iteratedPlayer.getUniqueId().equals(player.getUniqueId())) continue;
                this.damagers.put(iteratedPlayer, this.damagers.get(iteratedPlayer) + damage);
                this.aggro.put(iteratedPlayer, this.aggro.get(iteratedPlayer) + damage * ElitePlayerInventory.getPlayer(player).getLoudStrikesBonusMultiplier(false));
                return;
            }
        }
        this.damagers.put(player, damage);
        this.aggro.put(player, damage * ElitePlayerInventory.getPlayer(player).getLoudStrikesBonusMultiplier(false));
    }

    public boolean hasDamagers() {
        return !this.damagers.isEmpty();
    }

    public Map<Player, Double> getDamagers() {
        return this.damagers;
    }

    public boolean isCustomBossEntity() {
        return this instanceof CustomBossEntity;
    }

    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    public LivingEntity getUnsyncedLivingEntity() {
        return this.unsyncedLivingEntity;
    }

    public void setUnsyncedLivingEntity(LivingEntity newEntity) {
        this.unsyncedLivingEntity = newEntity;
    }

    public void setLivingEntity(LivingEntity livingEntity, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (livingEntity == null) {
            return;
        }
        if (!(this instanceof CustomBossEntity)) {
            this.spawnLocation = livingEntity.getLocation().clone();
        }
        this.livingEntity = livingEntity;
        this.unsyncedLivingEntity = livingEntity;
        this.entityType = livingEntity.getType();
        this.livingEntity.setCanPickupItems(false);
        if (livingEntity.getEquipment() != null) {
            livingEntity.getEquipment().setItemInMainHandDropChance(0.0f);
            livingEntity.getEquipment().setItemInOffHandDropChance(0.0f);
            livingEntity.getEquipment().setHelmetDropChance(0.0f);
            livingEntity.getEquipment().setChestplateDropChance(0.0f);
            livingEntity.getEquipment().setLeggingsDropChance(0.0f);
            livingEntity.getEquipment().setBootsDropChance(0.0f);
        }
        if (livingEntity.getType().equals((Object)EntityType.RABBIT)) {
            ((Rabbit)livingEntity).setRabbitType(Rabbit.Type.THE_KILLER_BUNNY);
        }
        if (this.entityType.equals((Object)EntityType.WOLF)) {
            Wolf wolf = (Wolf)livingEntity;
            wolf.setAngry(true);
            wolf.setBreed(false);
            KeepNeutralsAngry.showMeYouWarFace(this);
        }
        if (this.entityType.equals((Object)EntityType.POLAR_BEAR)) {
            KeepNeutralsAngry.showMeYouWarFace(this);
        }
        if (this.entityType.equals((Object)EntityType.ENDER_DRAGON) && ((EnderDragon)livingEntity).getBossBar() != null) {
            ((EnderDragon)livingEntity).getBossBar().setTitle(this.getName());
        }
        if (this.entityType.equals((Object)EntityType.LLAMA)) {
            KeepNeutralsAngry.showMeYouWarFace(this);
        }
        if (this.entityType.equals((Object)EntityType.IRON_GOLEM) && this instanceof CustomBossEntity) {
            KeepNeutralsAngry.showMeYouWarFace(this);
        }
        if (this.entityType.equals((Object)EntityType.GOAT)) {
            ((Goat)livingEntity).setScreaming(true);
        }
        if (livingEntity instanceof Bee) {
            KeepNeutralsAngry.showMeYouWarFace(this);
            ((Bee)livingEntity).setCannotEnterHiveTicks(Integer.MAX_VALUE);
        }
        if (livingEntity instanceof Wither) {
            Wither wither = (Wither)livingEntity;
            wither.getBossBar().setVisible(false);
        }
        this.spawnReason = spawnReason;
        this.getLivingEntity().setRemoveWhenFarAway(this.isPersistent == false);
        this.getLivingEntity().setPersistent(false);
        this.setMaxHealth();
        if (this.getName() == null) {
            this.setName(EliteMobProperties.getPluginData(this.entityType));
        }
        this.name = livingEntity.getCustomName();
        PersistentTagger.tagElite((Entity)livingEntity, this.eliteUUID);
        EntityTracker.registerEliteMob(this);
    }

    public void setNameVisible(boolean isVisible) {
        if (this.livingEntity == null) {
            return;
        }
        this.livingEntity.setCustomNameVisible(isVisible);
    }

    public void setMaxHealth() {
        this.defaultMaxHealth = EliteMobProperties.getPluginData(this.entityType) != null ? EliteMobProperties.getPluginData(this.entityType).getDefaultMaxHealth() : 20.0;
        this.maxHealth = ((double)this.level * 3.0 + this.defaultMaxHealth) * this.healthMultiplier;
        if (this.livingEntity != null) {
            AttributeManager.setAttribute(this.livingEntity, "generic_max_health", this.maxHealth);
        }
        if (this.health == null) {
            if (this.livingEntity != null) {
                this.livingEntity.setHealth(this.maxHealth);
            }
            this.health = this.maxHealth;
        } else if (this.livingEntity != null) {
            this.livingEntity.setHealth(Math.min(this.health, AttributeManager.getAttributeBaseValue(this.livingEntity, "generic_max_health")));
        }
    }

    public void setNormalizedMaxHealth() {
        this.defaultMaxHealth = MobCombatSettingsConfig.getNormalizedBaselineHealth();
        this.maxHealth = ((double)this.level * 3.0 + this.defaultMaxHealth) * this.healthMultiplier;
        if (this.livingEntity != null) {
            AttributeManager.setAttribute(this.livingEntity, "generic_max_health", this.maxHealth);
            this.livingEntity.setHealth(this.maxHealth);
        }
        this.health = this.maxHealth;
    }

    public void resetMaxHealth() {
        AttributeManager.setAttribute(this.livingEntity, "generic_max_health", this.maxHealth);
        this.livingEntity.setHealth(this.maxHealth);
        this.health = this.maxHealth;
    }

    public double getHealth() {
        if (this.livingEntity != null) {
            return this.livingEntity.getHealth();
        }
        if (this.health != null) {
            return this.health;
        }
        this.setMaxHealth();
        return this.health;
    }

    public void setHealth(double health) {
        if (this.livingEntity == null) {
            return;
        }
        this.health = Math.min(health, Math.min(this.maxHealth, AttributeManager.getAttributeBaseValue(this.livingEntity, "generic_max_health")));
        this.livingEntity.setHealth(this.health.doubleValue());
    }

    public void syncPluginHealth(double health) {
        this.health = health;
    }

    public void heal(double healAmount) {
        EliteMobHealEvent eliteMobHealEvent = new EliteMobHealEvent(this, healAmount);
        new EventCaller(eliteMobHealEvent);
        if (eliteMobHealEvent.isCancelled()) {
            return;
        }
        this.setHealth(this.health + healAmount);
    }

    public void fullHeal() {
        EliteMobHealEvent eliteMobHealEvent = new EliteMobHealEvent(this, true);
        new EventCaller(eliteMobHealEvent);
        if (eliteMobHealEvent.isCancelled()) {
            return;
        }
        this.setHealth(this.maxHealth);
        this.health = this.maxHealth;
        this.damagers.clear();
    }

    private void setArmor() {
        ItemMeta helmetMeta;
        if (!MobCombatSettingsConfig.isDoEliteArmor()) {
            return;
        }
        if (this.livingEntity.getEquipment() == null) {
            return;
        }
        if (!(this.livingEntity instanceof Zombie || this.livingEntity instanceof PigZombie || this.livingEntity instanceof Skeleton || this.livingEntity instanceof WitherSkeleton)) {
            return;
        }
        this.livingEntity.getEquipment().setBoots(new ItemStack(Material.AIR));
        this.livingEntity.getEquipment().setLeggings(new ItemStack(Material.AIR));
        this.livingEntity.getEquipment().setChestplate(new ItemStack(Material.AIR));
        this.livingEntity.getEquipment().setHelmet(new ItemStack(Material.AIR));
        if (this.level >= 5 && MobCombatSettingsConfig.isDoEliteHelmets()) {
            this.livingEntity.getEquipment().setHelmet(new ItemStack(Material.LEATHER_HELMET));
        }
        if (this.level >= 10) {
            this.livingEntity.getEquipment().setBoots(new ItemStack(Material.LEATHER_BOOTS));
        }
        if (this.level >= 15) {
            this.livingEntity.getEquipment().setLeggings(new ItemStack(Material.LEATHER_LEGGINGS));
        }
        if (this.level >= 20) {
            this.livingEntity.getEquipment().setChestplate(new ItemStack(Material.LEATHER_CHESTPLATE));
        }
        if (this.level >= 25 && MobCombatSettingsConfig.isDoEliteHelmets()) {
            this.livingEntity.getEquipment().setHelmet(new ItemStack(Material.CHAINMAIL_HELMET));
        }
        if (this.level >= 30) {
            this.livingEntity.getEquipment().setBoots(new ItemStack(Material.CHAINMAIL_BOOTS));
        }
        if (this.level >= 35) {
            this.livingEntity.getEquipment().setLeggings(new ItemStack(Material.CHAINMAIL_LEGGINGS));
        }
        if (this.level >= 40) {
            this.livingEntity.getEquipment().setChestplate(new ItemStack(Material.CHAINMAIL_CHESTPLATE));
        }
        if (this.level >= 45 && MobCombatSettingsConfig.isDoEliteHelmets()) {
            this.livingEntity.getEquipment().setHelmet(new ItemStack(Material.IRON_HELMET));
        }
        if (this.level >= 50) {
            this.livingEntity.getEquipment().setBoots(new ItemStack(Material.IRON_BOOTS));
        }
        if (this.level >= 55) {
            this.livingEntity.getEquipment().setLeggings(new ItemStack(Material.IRON_LEGGINGS));
        }
        if (this.level >= 60) {
            this.livingEntity.getEquipment().setChestplate(new ItemStack(Material.IRON_CHESTPLATE));
        }
        if (this.level >= 65) {
            this.livingEntity.getEquipment().setBoots(new ItemStack(Material.DIAMOND_BOOTS));
        }
        if (this.level >= 70 && MobCombatSettingsConfig.isDoEliteHelmets()) {
            this.livingEntity.getEquipment().setHelmet(new ItemStack(Material.DIAMOND_HELMET));
        }
        if (this.level >= 75) {
            this.livingEntity.getEquipment().setLeggings(new ItemStack(Material.DIAMOND_LEGGINGS));
        }
        if (this.level >= 80) {
            this.livingEntity.getEquipment().setChestplate(new ItemStack(Material.DIAMOND_CHESTPLATE));
        }
        if (this.livingEntity.getEquipment().getHelmet() != null && (helmetMeta = this.livingEntity.getEquipment().getHelmet().getItemMeta()) != null) {
            helmetMeta.setUnbreakable(true);
            this.livingEntity.getEquipment().getHelmet().setItemMeta(helmetMeta);
        }
    }

    public void randomizePowers(EliteMobProperties eliteMobProperties) {
        if (this.level < 1) {
            return;
        }
        int availableDefensivePowers = 0;
        int availableOffensivePowers = 0;
        int availableMiscellaneousPowers = 0;
        int availableMajorPowers = 0;
        if (this.level >= 10) {
            availableDefensivePowers = 1;
        }
        if (this.level >= 20) {
            availableOffensivePowers = 1;
        }
        if (this.level >= 30) {
            availableMiscellaneousPowers = 1;
        }
        if (this.level >= 40) {
            availableMajorPowers = 1;
        }
        if (this.level >= 50) {
            availableDefensivePowers = 2;
        }
        if (this.level >= 60) {
            availableOffensivePowers = 2;
        }
        if (this.level >= 70) {
            availableMiscellaneousPowers = 2;
        }
        if (this.level >= 80) {
            availableMajorPowers = 2;
        }
        this.applyPowers((HashSet)eliteMobProperties.getValidDefensivePowers().clone(), availableDefensivePowers);
        this.applyPowers((HashSet)eliteMobProperties.getValidOffensivePowers().clone(), availableOffensivePowers);
        this.applyPowers((HashSet)eliteMobProperties.getValidMiscellaneousPowers().clone(), availableMiscellaneousPowers);
        this.applyPowers((HashSet)eliteMobProperties.getValidMajorPowers().clone(), availableMajorPowers);
        new MinorPowerPowerStance(this);
        new MajorPowerPowerStance(this);
    }

    public void applyPowers(HashSet<PowersConfigFields> configFields, int availablePowerAmount) {
        configFields.removeIf(iteratedField -> !iteratedField.isEnabled());
        if (availablePowerAmount < 1) {
            return;
        }
        ArrayList<PowersConfigFields> localFields = new ArrayList<PowersConfigFields>(configFields);
        for (ElitePower mobPower : this.elitePowers) {
            localFields.remove(mobPower);
        }
        for (int i = 0; i < availablePowerAmount && localFields.size() >= 1; ++i) {
            PowersConfigFields selectedField = localFields.get(ThreadLocalRandom.current().nextInt(localFields.size()));
            try {
                ElitePower.addPower(this, selectedField);
                localFields.remove(selectedField);
                if (selectedField.getPowerType().equals((Object)PowersConfigFields.PowerType.MAJOR_ZOMBIE) || selectedField.getPowerType().equals((Object)PowersConfigFields.PowerType.MAJOR_BLAZE) || selectedField.getPowerType().equals((Object)PowersConfigFields.PowerType.MAJOR_ENDERMAN) || selectedField.getPowerType().equals((Object)PowersConfigFields.PowerType.MAJOR_GHAST) || selectedField.getPowerType().equals((Object)PowersConfigFields.PowerType.MAJOR_SKELETON)) {
                    ++this.majorPowerCount;
                    continue;
                }
                ++this.minorPowerCount;
                continue;
            }
            catch (Exception ex) {
                Logger.warn("Failed to instance new power!");
            }
        }
    }

    public void applyPowers(HashSet<PowersConfigFields> powersConfigFields) {
        powersConfigFields.forEach(field -> ElitePower.addPower(this, field));
    }

    public boolean hasPower(ElitePower mobPower) {
        for (ElitePower elitePower : this.elitePowers) {
            if (!elitePower.getPowersConfigFields().equals(mobPower.getPowersConfigFields())) continue;
            return true;
        }
        return false;
    }

    public boolean hasPower(PowersConfigFields mobPower) {
        for (ElitePower elitePower : this.elitePowers) {
            if (!elitePower.getPowersConfigFields().equals(mobPower)) continue;
            return true;
        }
        return false;
    }

    public ElitePower getPower(ElitePower elitePower) {
        for (ElitePower iteratedPower : this.getElitePowers()) {
            if (!iteratedPower.getClass().equals(elitePower.getClass())) continue;
            return iteratedPower;
        }
        return null;
    }

    public ElitePower getPower(String elitePower) {
        for (ElitePower iteratedPower : this.getElitePowers()) {
            if (!iteratedPower.getFileName().equals(elitePower)) continue;
            return iteratedPower;
        }
        return null;
    }

    public void setName(EliteMobProperties eliteMobProperties) {
        this.name = ChatColorConverter.convert(eliteMobProperties.getName().replace("$level", "" + this.level));
        this.livingEntity.setCustomName(this.name);
        this.livingEntity.setCustomNameVisible(DefaultConfig.isAlwaysShowNametags());
    }

    public void setName(String name, boolean applyToLivingEntity) {
        this.name = name;
        if (applyToLivingEntity) {
            this.livingEntity.setCustomName(name);
        }
    }

    public void setPersistent(boolean bool) {
        this.isPersistent = bool;
        if (this.livingEntity != null) {
            this.livingEntity.setRemoveWhenFarAway(this.isPersistent == false);
        }
    }

    public void doCooldown() {
        this.setInCooldown(true);
        new BukkitRunnable(){

            public void run() {
                EliteEntity.this.setInCooldown(false);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 300L);
    }

    public void doGlobalPowerCooldown(int ticks) {
        this.setInCooldown(true);
        new BukkitRunnable(){

            public void run() {
                EliteEntity.this.setInCooldown(false);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)ticks);
    }

    public void setTriggeredAntiExploit(boolean triggeredAntiExploit) {
        this.triggeredAntiExploit = triggeredAntiExploit;
        if (triggeredAntiExploit) {
            this.eliteLoot = false;
            this.vanillaLoot = false;
        }
    }

    public void incrementAntiExploit(int value, String cause) {
        this.antiExploitPoints += value;
        if (this.antiExploitPoints > AntiExploitConfig.getAntiExploitThreshold()) {
            this.setTriggeredAntiExploit(true);
            AntiExploitMessage.sendWarning(this.livingEntity, cause);
        }
    }

    public void decrementAntiExploit(int value) {
        this.antiExploitPoints -= value;
    }

    public void setInAntiExploitCooldown() {
        this.inAntiExploitCooldown = true;
        new BukkitRunnable(){

            public void run() {
                EliteEntity.this.inAntiExploitCooldown = false;
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 20L);
    }

    public void setCombatGracePeriod(int delayInTicks) {
        this.inCombatGracePeriod = true;
        new BukkitRunnable(){

            public void run() {
                EliteEntity.this.inCombatGracePeriod = false;
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)delayInTicks);
    }

    public void addGlobalReinforcement(CustomBossEntity customBossEntity) {
        this.globalReinforcementEntities.add(customBossEntity);
    }

    public void addReinforcement(CustomBossEntity customBossEntity) {
        this.eliteReinforcementEntities.add(customBossEntity);
    }

    public void addReinforcement(Entity entity) {
        this.nonEliteReinforcementEntities.add(entity);
    }

    public boolean isValid() {
        if (this.livingEntity == null) {
            return false;
        }
        return this.livingEntity.isValid();
    }

    public boolean exists() {
        if (this.livingEntity == null) {
            return false;
        }
        return !this.livingEntity.isDead();
    }

    public Location getLocation() {
        if (this.livingEntity != null) {
            return this.livingEntity.getLocation();
        }
        if (this.unsyncedLivingEntity != null) {
            return this.unsyncedLivingEntity.getLocation();
        }
        return null;
    }

    public void remove(RemovalReason removalReason) {
        LivingEntity livingEntity;
        if (this.livingEntity != null && !(this instanceof CustomBossEntity)) {
            EntityTracker.getEliteMobEntities().remove(this.eliteUUID);
        }
        if (this.livingEntity != null && !removalReason.equals((Object)RemovalReason.DEATH)) {
            this.livingEntity.remove();
        }
        if ((livingEntity = this.livingEntity) instanceof EnderDragon) {
            EnderDragon enderDragon = (EnderDragon)livingEntity;
            if (removalReason.equals((Object)RemovalReason.DEATH)) {
                enderDragon.setPhase(EnderDragon.Phase.DYING);
                if (enderDragon.getDragonBattle() != null) {
                    enderDragon.getDragonBattle().generateEndPortal(false);
                }
            }
        }
        this.livingEntity = null;
    }

    public void removeReinforcement(CustomBossEntity customBossEntity) {
        this.eliteReinforcementEntities.remove(customBossEntity);
        this.globalReinforcementEntities.remove(customBossEntity);
    }

    public int getGlobalReinforcementsCount() {
        return this.globalReinforcementEntities.size();
    }

    public HashSet<String> getTags() {
        return this.customMetadata;
    }

    public boolean hasTag(String tag) {
        return this.customMetadata.contains(tag);
    }

    public void addTag(String tag) {
        this.customMetadata.add(tag);
    }

    public void addTags(List<String> tags) {
        this.customMetadata.addAll(tags);
    }

    public void removeTag(String tag) {
        this.customMetadata.remove(tag);
    }

    public void removeTags(List<String> tags) {
        this.customMetadata.removeAll(tags);
    }

    @Generated
    public HashSet<ElitePower> getElitePowers() {
        return this.elitePowers;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public void setLevel(int level) {
        this.level = level;
    }

    @Generated
    public double getMaxHealth() {
        return this.maxHealth;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getMinorPowerCount() {
        return this.minorPowerCount;
    }

    @Generated
    public int getMajorPowerCount() {
        return this.majorPowerCount;
    }

    @Generated
    public boolean isMinorVisualEffect() {
        return this.minorVisualEffect;
    }

    @Generated
    public void setMinorVisualEffect(boolean minorVisualEffect) {
        this.minorVisualEffect = minorVisualEffect;
    }

    @Generated
    public boolean isMajorVisualEffect() {
        return this.majorVisualEffect;
    }

    @Generated
    public void setMajorVisualEffect(boolean majorVisualEffect) {
        this.majorVisualEffect = majorVisualEffect;
    }

    @Generated
    public boolean isVisualEffectObfuscated() {
        return this.visualEffectObfuscated;
    }

    @Generated
    public void setVisualEffectObfuscated(boolean visualEffectObfuscated) {
        this.visualEffectObfuscated = visualEffectObfuscated;
    }

    @Generated
    public boolean isNaturalEntity() {
        return this.isNaturalEntity;
    }

    @Generated
    public Boolean getIsPersistent() {
        return this.isPersistent;
    }

    @Generated
    public boolean isVanillaLoot() {
        return this.vanillaLoot;
    }

    @Generated
    public void setVanillaLoot(boolean vanillaLoot) {
        this.vanillaLoot = vanillaLoot;
    }

    @Generated
    public boolean isEliteLoot() {
        return this.eliteLoot;
    }

    @Generated
    public void setEliteLoot(boolean eliteLoot) {
        this.eliteLoot = eliteLoot;
    }

    @Generated
    public boolean isRandomLoot() {
        return this.randomLoot;
    }

    @Generated
    public void setRandomLoot(boolean randomLoot) {
        this.randomLoot = randomLoot;
    }

    @Generated
    public CreatureSpawnEvent.SpawnReason getSpawnReason() {
        return this.spawnReason;
    }

    @Generated
    public double getHealthMultiplier() {
        return this.healthMultiplier;
    }

    @Generated
    public void setHealthMultiplier(double healthMultiplier) {
        this.healthMultiplier = healthMultiplier;
    }

    @Generated
    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    @Generated
    public void setDamageMultiplier(double damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    @Generated
    public boolean isInCooldown() {
        return this.inCooldown;
    }

    @Generated
    public void setInCooldown(boolean inCooldown) {
        this.inCooldown = inCooldown;
    }

    @Generated
    public boolean isTriggeredAntiExploit() {
        return this.triggeredAntiExploit;
    }

    @Generated
    public boolean isInAntiExploitCooldown() {
        return this.inAntiExploitCooldown;
    }

    @Generated
    public boolean isInCombat() {
        return this.inCombat;
    }

    @Generated
    public void setInCombat(boolean inCombat) {
        this.inCombat = inCombat;
    }

    @Generated
    public boolean isInCombatGracePeriod() {
        return this.inCombatGracePeriod;
    }

    @Generated
    public void setSummoningEntity(EliteEntity summoningEntity) {
        this.summoningEntity = summoningEntity;
    }

    @Generated
    public void setSpawnLocation(Location spawnLocation) {
        this.spawnLocation = spawnLocation;
    }

    @Generated
    public boolean isDying() {
        return this.dying;
    }

    @Generated
    public void setDying(boolean dying) {
        this.dying = dying;
    }

    @Generated
    public boolean isHealing() {
        return this.healing;
    }

    @Generated
    public void setHealing(boolean healing) {
        this.healing = healing;
    }
}

