/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.MinorPower;
import com.magmaguy.elitemobs.utils.NonSolidBlockTypes;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Monster;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ArrowFireworks
extends MinorPower
implements Listener {
    public ArrowFireworks() {
        super(PowersConfig.getPower("arrow_fireworks.yml"));
    }

    private static void doArrowFireworks(final EliteEntity eliteEntity) {
        Location centeredLocation = eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 3, 0));
        for (int x = 0; x < eliteEntity.getDamagers().size(); ++x) {
            Location newLocation = centeredLocation.clone();
            boolean validBlockFound = false;
            for (int i = 0; i < 5; ++i) {
                Vector randomizedVector = new Vector(ThreadLocalRandom.current().nextInt(9) - 4, 0, ThreadLocalRandom.current().nextInt(9) - 4);
                newLocation = centeredLocation.clone().add(randomizedVector);
                if (!NonSolidBlockTypes.isPassthrough(newLocation.getBlock().getType())) continue;
                validBlockFound = true;
                break;
            }
            if (!validBlockFound) {
                return;
            }
            final SpectralArrow rocketArrow = (SpectralArrow)newLocation.getWorld().spawnEntity(newLocation, EntityType.SPECTRAL_ARROW);
            rocketArrow.setShooter((ProjectileSource)eliteEntity.getLivingEntity());
            rocketArrow.setVelocity(new Vector(0.0, 0.5, 0.0));
            rocketArrow.setGravity(false);
            rocketArrow.setGlowing(true);
            new BukkitRunnable(){
                int counter = 0;

                public void run() {
                    if (!rocketArrow.isValid() || !eliteEntity.isValid()) {
                        this.cancel();
                        return;
                    }
                    if ((double)this.counter < 30.0) {
                        rocketArrow.getWorld().spawnParticle(Particle.CRIT, rocketArrow.getLocation(), 1);
                    } else {
                        for (int i = 0; i < 30; ++i) {
                            Arrow fireworkArrow = (Arrow)rocketArrow.getWorld().spawnEntity(rocketArrow.getLocation(), EntityType.ARROW);
                            Vector randomizedDirection = new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) * 2.0, (ThreadLocalRandom.current().nextDouble() - 0.5) * 2.0, (ThreadLocalRandom.current().nextDouble() - 0.5) * 2.0);
                            fireworkArrow.setVelocity(randomizedDirection);
                            fireworkArrow.setShooter((ProjectileSource)eliteEntity.getLivingEntity());
                            fireworkArrow.setGlowing(true);
                        }
                        rocketArrow.remove();
                        this.cancel();
                    }
                    ++this.counter;
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        }
    }

    @EventHandler
    public void onEliteDamagedByPlayer(EliteMobDamagedByPlayerEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEliteMobEntity().getLivingEntity() instanceof Monster)) {
            return;
        }
        ArrowFireworks arrowFireworks = (ArrowFireworks)event.getEliteMobEntity().getPower(this);
        if (arrowFireworks == null) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.15) {
            return;
        }
        ArrowFireworks.doArrowFireworks(event.getEliteMobEntity());
    }
}

