/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.CombatEnterScanPower;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ChannelHealing
extends CombatEnterScanPower {
    public ChannelHealing() {
        super(PowersConfig.getPower("channel_healing.yml"));
    }

    @Override
    protected void finishActivation(final EliteEntity eliteEntity) {
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                if (ChannelHealing.this.doExit(eliteEntity) || ChannelHealing.this.isInCooldown(eliteEntity)) {
                    return;
                }
                ChannelHealing.this.doPower(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 40L);
    }

    private void doPower(EliteEntity eliteEntity) {
        for (Entity entity : eliteEntity.getLivingEntity().getNearbyEntities(20.0, 20.0, 20.0)) {
            EliteEntity parsedEntity = EntityTracker.getEliteMobEntity(entity);
            if (parsedEntity == null || parsedEntity.getHealth() / parsedEntity.getMaxHealth() > 0.8 || parsedEntity.isHealing()) continue;
            this.channelHealing(eliteEntity, parsedEntity);
            return;
        }
    }

    private void channelHealing(final EliteEntity healer, final EliteEntity damagedEntity) {
        super.setInCooldown(healer, true);
        healer.getLivingEntity().setAI(false);
        damagedEntity.setHealing(true);
        new BukkitRunnable(){
            int timer = 0;

            public void run() {
                if (!healer.isValid() || !damagedEntity.isValid() || damagedEntity.getHealth() / damagedEntity.getMaxHealth() > 0.8 || healer.getLocation().distance(damagedEntity.getLocation()) > 25.0) {
                    this.cancel();
                    ChannelHealing.this.setInCooldown(healer, false);
                    ChannelHealing.this.doCooldown(healer);
                    damagedEntity.setHealing(false);
                    if (healer.isValid()) {
                        healer.getLivingEntity().setAI(true);
                    }
                    return;
                }
                if (this.timer % 10 == 0 && this.timer > 0) {
                    double healAmount = (double)healer.getLevel() / 2.0;
                    damagedEntity.heal(healAmount);
                    damagedEntity.getLocation().getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, damagedEntity.getLocation().add(new Vector(0, 1, 0)), 20, 0.1, 0.1, 0.1);
                }
                Vector toDamaged = damagedEntity.getLocation().add(new Vector(0, 1, 0)).subtract(healer.getLocation().add(new Vector(0, 1, 0))).toVector().normalize().multiply(0.5);
                Location rayLocation = healer.getLocation().add(new Vector(0, 1, 0)).add(toDamaged);
                for (int i = 0; i < 55; ++i) {
                    rayLocation.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, rayLocation, 1, toDamaged.getX(), toDamaged.getY(), toDamaged.getZ(), 0.2);
                    rayLocation.add(toDamaged);
                    if (rayLocation.distance(damagedEntity.getLocation()) < 2.0) break;
                }
                ++this.timer;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 2L);
    }

    @Override
    protected void finishDeactivation(EliteEntity eliteEntity) {
    }
}

