/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.combatsystem.EliteProjectile;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.CombatEnterScanPower;
import com.magmaguy.elitemobs.utils.EnderDragonPhaseSimplifier;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Projectile;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EnderDragonDiscoFireballs
extends CombatEnterScanPower {
    int randomTiltSeed;
    private ArrayList<Vector> relativeLocationOffsets;
    private ArrayList<Location> realLocations = new ArrayList();
    private int warningCounter = 0;
    private ArrayList<Fireball> fireballs = new ArrayList();

    public EnderDragonDiscoFireballs() {
        super(PowersConfig.getPower("ender_dragon_disco_fireballs.yml"));
    }

    @Override
    protected void finishActivation(final EliteEntity eliteEntity) {
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                if (EnderDragonDiscoFireballs.this.doExit(eliteEntity) || EnderDragonDiscoFireballs.this.isInCooldown(eliteEntity)) {
                    return;
                }
                if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && !EnderDragonPhaseSimplifier.isLanded(((EnderDragon)eliteEntity.getLivingEntity()).getPhase())) {
                    return;
                }
                EnderDragonDiscoFireballs.this.doPower(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 10L);
    }

    @Override
    protected void finishDeactivation(EliteEntity eliteEntity) {
    }

    private void doPower(final EliteEntity eliteEntity) {
        this.doCooldown(eliteEntity);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (EnderDragonDiscoFireballs.this.doExit(eliteEntity) || eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && !EnderDragonPhaseSimplifier.isLanded(((EnderDragon)eliteEntity.getLivingEntity()).getPhase())) {
                    this.cancel();
                    return;
                }
                if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON)) {
                    ((EnderDragon)eliteEntity.getLivingEntity()).setPhase(EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET);
                }
                if (this.counter == 0) {
                    EnderDragonDiscoFireballs.this.generateLocations();
                    EnderDragonDiscoFireballs.this.commitLocations(eliteEntity);
                    EnderDragonDiscoFireballs.this.randomTiltSeed = ThreadLocalRandom.current().nextInt();
                    EnderDragonDiscoFireballs.this.warningCounter = 0;
                }
                if (this.counter < 120) {
                    EnderDragonDiscoFireballs.this.doWarningPhase(eliteEntity);
                    ++EnderDragonDiscoFireballs.this.warningCounter;
                }
                if (this.counter > 120) {
                    EnderDragonDiscoFireballs.this.doDamagePhase(eliteEntity);
                    this.cancel();
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void generateLocations() {
        this.relativeLocationOffsets = new ArrayList();
        for (int i = 0; i < 12; ++i) {
            this.relativeLocationOffsets.add(new Vector(7, 0, 0).rotateAroundY(0.5235987755982988 * (double)i));
        }
    }

    private void commitLocations(EliteEntity eliteEntity) {
        this.realLocations = new ArrayList();
        for (Vector vector : this.relativeLocationOffsets) {
            this.realLocations.add(eliteEntity.getLivingEntity().getLocation().clone().add(vector));
        }
    }

    private void doWarningPhase(EliteEntity eliteEntity) {
        if (this.warningCounter == 0) {
            this.fireballs = new ArrayList();
            for (Location location : this.realLocations) {
                Fireball fireball = (Fireball)location.getWorld().spawnEntity(location, EntityType.FIREBALL);
                EntityTracker.registerProjectileEntity((Projectile)fireball);
                EliteProjectile.signExplosiveWithPower((Projectile)fireball, this.getFileName());
                this.fireballs.add(fireball);
            }
        }
        ++this.warningCounter;
        for (Fireball fireball : this.fireballs) {
            if (!fireball.isValid()) continue;
            if (this.warningCounter % 5 == 0) {
                Vector relativeLocation = fireball.getLocation().clone().subtract(eliteEntity.getLivingEntity().getLocation()).toVector().rotateAroundY(0.06544984694978735);
                Location rotatedLocation = eliteEntity.getLivingEntity().getLocation().clone().add(relativeLocation);
                Vector velocity = rotatedLocation.clone().subtract(fireball.getLocation()).toVector().multiply(0.001);
                fireball.setDirection(velocity);
                fireball.setVelocity(velocity);
                fireball.setYield(5.0f);
            }
            this.generateVisualParticles(eliteEntity, fireball);
        }
    }

    private void doDamagePhase(EliteEntity eliteEntity) {
        for (Fireball fireball : this.fireballs) {
            fireball.setDirection(this.generateDownwardsVector(eliteEntity, fireball).multiply(0.1));
        }
    }

    private Vector generateDownwardsVector(EliteEntity eliteEntity, Fireball fireball) {
        double yValue = Math.cos(this.warningCounter) / 2.0 - 0.5;
        return fireball.getLocation().clone().subtract(eliteEntity.getLivingEntity().getLocation()).toVector().normalize().setY(yValue);
    }

    private void generateVisualParticles(EliteEntity eliteEntity, Fireball fireball) {
        Vector downwardsVector = this.generateDownwardsVector(eliteEntity, fireball);
        Location particleLocation = fireball.getLocation().clone();
        for (int i = 0; i < 200; ++i) {
            particleLocation.add(downwardsVector.clone().multiply(0.3));
            if (!particleLocation.getBlock().isPassable()) break;
            fireball.getWorld().spawnParticle(Particle.SMOKE, particleLocation, 1, 1.0, 0.0, 0.0, 0.0);
        }
    }
}

