/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.config.powers.PowersConfigFields;
import com.magmaguy.elitemobs.explosionregen.Explosion;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class FireworksBarrage
extends BossPower {
    public FireworksBarrage() {
        super(PowersConfig.getPower("fireworks_barrage.yml"));
    }

    public void doFireworksBarrage(final EliteEntity eliteEntity) {
        eliteEntity.getLivingEntity().setAI(false);
        if (eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 10, 0)).getBlock().getType().equals((Object)Material.AIR) && !eliteEntity.getLivingEntity().getType().equals((Object)EntityType.GHAST)) {
            eliteEntity.getLivingEntity().teleport(eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 10, 0)));
        }
        new BukkitRunnable(){
            final Location initialLocation;
            int counter;
            {
                this.initialLocation = eliteEntity.getLivingEntity().getLocation().clone();
                this.counter = 0;
            }

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 2; ++i) {
                    Firework firework = (Firework)eliteEntity.getLivingEntity().getWorld().spawnEntity(eliteEntity.getLivingEntity().getLocation(), EntityType.FIREWORK_ROCKET);
                    FireworkMeta fireworkMeta = firework.getFireworkMeta();
                    fireworkMeta.setPower(10);
                    fireworkMeta.addEffect(FireworkEffect.builder().withColor(new Color[]{Color.RED, Color.WHITE, Color.BLUE}).flicker(true).build());
                    firework.setFireworkMeta(fireworkMeta);
                    firework.setVelocity(new Vector(ThreadLocalRandom.current().nextDouble(-0.5, 0.5), ThreadLocalRandom.current().nextDouble(), ThreadLocalRandom.current().nextDouble(-0.5, 0.5)));
                    firework.setPersistent(false);
                }
                for (Entity nearbyEntity : eliteEntity.getLivingEntity().getNearbyEntities(20.0, 20.0, 20.0)) {
                    if (!(nearbyEntity instanceof Player) || !((Player)nearbyEntity).getGameMode().equals((Object)GameMode.ADVENTURE) && !((Player)nearbyEntity).getGameMode().equals((Object)GameMode.SURVIVAL)) continue;
                    Firework firework = (Firework)eliteEntity.getLivingEntity().getWorld().spawnEntity(eliteEntity.getLivingEntity().getLocation(), EntityType.FIREWORK_ROCKET);
                    FireworkMeta fireworkMeta = firework.getFireworkMeta();
                    fireworkMeta.setPower(10);
                    fireworkMeta.addEffect(FireworkEffect.builder().withColor(new Color[]{Color.RED, Color.WHITE, Color.BLUE}).flicker(true).build());
                    firework.setFireworkMeta(fireworkMeta);
                    firework.setVelocity(((Player)nearbyEntity).getEyeLocation().clone().subtract(firework.getLocation()).toVector().normalize().multiply(0.5));
                    firework.setShotAtAngle(true);
                    firework.setPersistent(false);
                    new FireworkTask(firework, nearbyEntity.getLocation().clone(), eliteEntity);
                }
                ++this.counter;
                if (this.counter > 10) {
                    this.cancel();
                    eliteEntity.getLivingEntity().setAI(true);
                    eliteEntity.getLivingEntity().teleport(this.initialLocation);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 10L);
    }

    private class FireworkTask {
        public FireworkTask(final Firework firework, final Location targetLocation, final EliteEntity eliteEntity) {
            new BukkitRunnable(){
                int counter = 0;

                public void run() {
                    ++this.counter;
                    if (firework == null || this.counter > 100) {
                        this.cancel();
                        return;
                    }
                    if (firework.getLocation().distanceSquared(targetLocation) < Math.pow(0.01, 2.0)) {
                        firework.detonate();
                        ArrayList<Block> blockList = new ArrayList<Block>();
                        for (int x = -1; x < 2; ++x) {
                            for (int y = -1; y < 2; ++y) {
                                for (int z = -1; z < 2; ++z) {
                                    blockList.add(firework.getLocation().clone().add(new Vector(x, y, z)).getBlock());
                                }
                            }
                        }
                        Explosion.generateFakeExplosion(blockList, (Entity)eliteEntity.getLivingEntity(), (PowersConfigFields)FireworksBarrage.this.getPowersConfigFields(), firework.getLocation());
                    }
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
        }
    }

    public static class FireworksBarrageEvents
    implements Listener {
        @EventHandler
        public void onDamage(EliteMobDamagedByPlayerEvent event) {
            FireworksBarrage fireworksBarrage = (FireworksBarrage)event.getEliteMobEntity().getPower(new FireworksBarrage());
            if (fireworksBarrage == null) {
                return;
            }
            if (!FireworksBarrage.eventIsValid(event, fireworksBarrage)) {
                return;
            }
            if (ThreadLocalRandom.current().nextDouble() > 0.25) {
                return;
            }
            fireworksBarrage.doCooldown(event.getEliteMobEntity());
            fireworksBarrage.doFireworksBarrage(event.getEliteMobEntity());
        }
    }
}

