/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.CombatEnterScanPower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlasmaBlaster
extends CombatEnterScanPower {
    public PlasmaBlaster() {
        super(PowersConfig.getPower("plasma_blaster.yml"));
    }

    @Override
    protected void finishActivation(final EliteEntity eliteEntity) {
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                if (PlasmaBlaster.this.doExit(eliteEntity) || PlasmaBlaster.this.isInCooldown(eliteEntity)) {
                    return;
                }
                PlasmaBlaster.this.doPower(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 80L);
    }

    private void doPower(EliteEntity eliteEntity) {
        for (Entity entity : eliteEntity.getLivingEntity().getNearbyEntities(30.0, 30.0, 30.0)) {
            if (!entity.getType().equals((Object)EntityType.PLAYER) || ((Player)entity).getGameMode().equals((Object)GameMode.SPECTATOR)) continue;
            Vector shotVector = entity.getLocation().subtract(eliteEntity.getLivingEntity().getLocation()).toVector().normalize().multiply(0.5);
            this.createProjectile(shotVector, eliteEntity.getLocation(), eliteEntity, (Player)entity);
            break;
        }
    }

    private void createProjectile(final Vector shotVector, final Location sourceLocation, final EliteEntity sourceEntity, final Player player) {
        new BukkitRunnable(){
            final Location currentLocation;
            int counter;
            {
                this.currentLocation = sourceLocation.clone().add(new Vector(0, 1, 0));
                this.counter = 0;
            }

            public void run() {
                if (this.counter > 60) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                if (player.getBoundingBox().overlaps(new Vector(this.currentLocation.getX() - 0.5, this.currentLocation.getY() - 0.5, this.currentLocation.getZ() - 0.5), new Vector(this.currentLocation.getX() + 0.5, this.currentLocation.getY() + 0.5, this.currentLocation.getZ() + 0.5))) {
                    PlasmaBlaster.this.doDamage(player, sourceEntity);
                }
                if (this.counter % 5 == 0) {
                    PlasmaBlaster.this.doVisualEffect(this.currentLocation, this.counter);
                }
                this.currentLocation.add(shotVector);
                if (!this.currentLocation.getBlock().isPassable()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void doDamage(Player player, EliteEntity sourceEntity) {
        player.damage(1.0, (Entity)sourceEntity.getLivingEntity());
        this.doDamageFireworks(player.getLocation().clone().add(new Vector(0, 1, 0)));
    }

    private void doDamageFireworks(Location endLocation) {
        for (int i = 0; i < 200; ++i) {
            endLocation.getWorld().spawnParticle(Particle.DUST, endLocation.getX(), endLocation.getY(), endLocation.getZ(), 1, 3.0, 3.0, 3.0, 1.0, (Object)new Particle.DustOptions(Color.fromRGB((int)ThreadLocalRandom.current().nextInt(122, 255), (int)ThreadLocalRandom.current().nextInt(122, 255), (int)ThreadLocalRandom.current().nextInt(0, 100)), 1.0f));
        }
    }

    private void doVisualEffect(Location location, int counter) {
        location.getWorld().spawnParticle(Particle.DUST, location.getX(), location.getY(), location.getZ(), 10, 0.1 * (double)counter / 12.0, 0.1 * (double)counter / 12.0, 0.1 * (double)counter / 12.0, 1.0, (Object)new Particle.DustOptions(Color.fromRGB((int)ThreadLocalRandom.current().nextInt(0, 100), (int)ThreadLocalRandom.current().nextInt(122, 255), (int)ThreadLocalRandom.current().nextInt(0, 100)), 1.0f));
    }

    @Override
    protected void finishDeactivation(EliteEntity eliteEntity) {
    }
}

