/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts;

import com.magmaguy.elitemobs.api.EliteMobDamagedByEliteMobEvent;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.EliteMobDamagedEvent;
import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.api.EliteMobEnterCombatEvent;
import com.magmaguy.elitemobs.api.EliteMobExitCombatEvent;
import com.magmaguy.elitemobs.api.EliteMobHealEvent;
import com.magmaguy.elitemobs.api.EliteMobSpawnEvent;
import com.magmaguy.elitemobs.api.EliteMobTargetPlayerEvent;
import com.magmaguy.elitemobs.api.ElitePhaseSwitchEvent;
import com.magmaguy.elitemobs.api.PlayerDamagedByEliteMobEvent;
import com.magmaguy.elitemobs.api.ScriptZoneEnterEvent;
import com.magmaguy.elitemobs.api.ScriptZoneLeaveEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.elitemobs.powers.scripts.FallingEntityDataPair;
import com.magmaguy.elitemobs.powers.scripts.ScriptAction;
import com.magmaguy.magmacore.util.Logger;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;

public class ScriptListener
implements Listener {
    public static HashMap<FallingBlock, FallingEntityDataPair> fallingBlocks = new HashMap();
    public static HashMap<Entity, FallingEntityDataPair> fallingEntities = new HashMap();

    public static void runEvent(FallingEntityDataPair fallingEntityDataPair, Location landingLocation) {
        for (String string : fallingEntityDataPair.getScriptAction().getBlueprint().getLandingScripts()) {
            EliteScript iteratedScript = fallingEntityDataPair.getScriptAction().getEliteScriptMap().get(string);
            if (iteratedScript == null) {
                Logger.warn("Elite script " + string + " does not exist for landing scripts!");
                return;
            }
            iteratedScript.check(landingLocation, fallingEntityDataPair.getScriptActionData());
        }
    }

    @EventHandler
    public void onEliteMobDamagedByPlayerEvent(EliteMobDamagedByPlayerEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.runEvent(event, event.getEliteMobEntity(), event.getPlayer());
    }

    @EventHandler
    public void onEliteMobDamagedByEliteMobEvent(EliteMobDamagedByEliteMobEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.runEventGeneric(event, event.getDamagee(), event.getDamager().getLivingEntity());
    }

    @EventHandler
    public void onEliteMobDamagedEvent(EliteMobDamagedEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.runEvent(event, event.getEliteEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEliteMobsEnterCombatEvent(EliteMobEnterCombatEvent event) {
        this.runEvent(event, event.getEliteMobEntity(), event.getTargetEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEliteMobDeathEvent(EliteMobDeathEvent event) {
        this.runEvent(event, event.getEliteEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEliteMobExitCombatEvent(EliteMobExitCombatEvent event) {
        this.runEvent(event, event.getEliteMobEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEliteMobHealEvent(EliteMobHealEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.runEvent(event, event.getEliteEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEliteMobTargetPlayerEvent(EliteMobTargetPlayerEvent event) {
        this.runEvent(event, event.getEliteMobEntity(), event.getPlayer());
    }

    @EventHandler
    public void onPlayerDamagedByEliteMobEvent(PlayerDamagedByEliteMobEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.runEvent(event, event.getEliteMobEntity(), event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEliteMobSpawnEvent(EliteMobSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.runEvent(event, event.getEliteMobEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onElitePhaseSwitchEvent(ElitePhaseSwitchEvent event) {
        this.runEvent(event, event.getCustomBossEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        if (fallingBlocks.isEmpty()) {
            return;
        }
        FallingEntityDataPair fallingEntityDataPair = fallingBlocks.get(event.getEntity());
        if (fallingEntityDataPair == null) {
            return;
        }
        ScriptAction scriptAction = fallingEntityDataPair.getScriptAction();
        if (scriptAction == null) {
            return;
        }
        event.setCancelled(true);
        ScriptListener.runEvent(fallingBlocks.get(event.getEntity()), event.getBlock().getLocation());
        fallingBlocks.remove(event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onZoneEnterEvent(ScriptZoneEnterEvent event) {
        this.runEventGeneric(event, event.getEliteEntity(), event.getEntity());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onZoneLeaveEvent(ScriptZoneLeaveEvent event) {
        this.runEventGeneric(event, event.getEliteEntity(), event.getEntity());
    }

    private void runEvent(Event event, EliteEntity eliteEntity) {
        for (ElitePower elitePower : eliteEntity.getElitePowers()) {
            if (!(elitePower instanceof EliteScript)) continue;
            EliteScript eliteScript = (EliteScript)elitePower;
            eliteScript.check(event, eliteEntity, (Player)null);
        }
    }

    private void runEventGeneric(Event event, EliteEntity eliteEntity, LivingEntity directTarget) {
        for (ElitePower elitePower : eliteEntity.getElitePowers()) {
            if (!(elitePower instanceof EliteScript)) continue;
            EliteScript eliteScript = (EliteScript)elitePower;
            eliteScript.check(event, eliteEntity, directTarget);
        }
    }

    private void runEvent(Event event, EliteEntity eliteEntity, Player player) {
        for (ElitePower elitePower : eliteEntity.getElitePowers()) {
            if (!(elitePower instanceof EliteScript)) continue;
            EliteScript eliteScript = (EliteScript)elitePower;
            eliteScript.check(event, eliteEntity, player);
        }
    }
}

