/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts.caching;

import com.magmaguy.elitemobs.config.CustomConfigFields;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptActionsBlueprint;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptConditionsBlueprint;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptCooldownsBlueprint;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptEventsBlueprint;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptZoneBlueprint;
import com.magmaguy.elitemobs.utils.MapListInterpreter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class EliteScriptBlueprint {
    private static final HashMap<CustomConfigFields, EliteScriptBlueprint> blueprints = new HashMap();
    private final CustomConfigFields customConfigFields;
    private final ScriptActionsBlueprint scriptActionsBlueprint;
    private final ScriptConditionsBlueprint scriptConditionsBlueprint;
    private final ScriptZoneBlueprint scriptZoneBlueprint;
    private final ScriptEventsBlueprint scriptEventsBlueprint;
    private final ScriptCooldownsBlueprint scriptCooldownsBlueprint;
    private final String filename;
    private final String scriptName;

    public EliteScriptBlueprint(CustomConfigFields customConfigFields, ConfigurationSection configurationSection, String scriptName) {
        this.filename = customConfigFields.getFilename();
        this.scriptName = configurationSection.getName();
        this.customConfigFields = customConfigFields;
        this.scriptEventsBlueprint = new ScriptEventsBlueprint(configurationSection, scriptName, this.filename);
        this.scriptConditionsBlueprint = new ScriptConditionsBlueprint(configurationSection, scriptName, this.filename);
        this.scriptZoneBlueprint = new ScriptZoneBlueprint(configurationSection, scriptName, this.filename);
        this.scriptActionsBlueprint = new ScriptActionsBlueprint(configurationSection, scriptName, this.filename);
        this.scriptCooldownsBlueprint = new ScriptCooldownsBlueprint(configurationSection, scriptName, this.filename);
        blueprints.put(customConfigFields, this);
    }

    public static List<EliteScriptBlueprint> parseBossScripts(ConfigurationSection configurationSection, CustomConfigFields customConfigFields) {
        if (configurationSection == null) {
            return Collections.emptyList();
        }
        ArrayList<EliteScriptBlueprint> eliteScripts = new ArrayList<EliteScriptBlueprint>();
        HashMap<String, EliteScriptBlueprint> permanentMap = new HashMap<String, EliteScriptBlueprint>();
        EliteScriptBlueprint.checkLegacyFormat(configurationSection, customConfigFields);
        for (Map.Entry entry : configurationSection.getValues(false).entrySet()) {
            EliteScriptBlueprint eliteScript = new EliteScriptBlueprint(customConfigFields, configurationSection.getConfigurationSection((String)entry.getKey()), (String)entry.getKey());
            eliteScripts.add(eliteScript);
            permanentMap.put((String)entry.getKey(), eliteScript);
        }
        return eliteScripts;
    }

    private static void checkLegacyFormat(ConfigurationSection configurationSection, CustomConfigFields customConfigFields) {
        boolean updated = false;
        for (String key : configurationSection.getKeys(true)) {
            String[] splitKeys = key.split("\\.");
            if (splitKeys.length < 1) continue;
            String truncatedKey = splitKeys[splitKeys.length - 1];
            if (truncatedKey.equalsIgnoreCase("target") && configurationSection.get(key) instanceof String) {
                updated = true;
                String overallKey = key.replace(".target", "");
                new OldDataContainer(overallKey, configurationSection, overallKey);
            }
            if (!truncatedKey.equalsIgnoreCase("Actions")) continue;
            ArrayList immutableMapList = new ArrayList(configurationSection.getMapList(key));
            ArrayList mutableMapList = new ArrayList();
            immutableMapList.forEach(map -> mutableMapList.add(new HashMap(map)));
            for (Map map2 : mutableMapList) {
                HashMap clonedMap = new HashMap(map2);
                for (Map.Entry entry : clonedMap.entrySet()) {
                    if (!((String)entry.getKey()).equalsIgnoreCase("target") || entry.getValue() instanceof Map) continue;
                    updated = true;
                    new OldDataContainer(map2, customConfigFields.getFilename());
                }
            }
            if (!updated) continue;
            configurationSection.set(key, mutableMapList);
        }
        if (!updated) {
            return;
        }
        try {
            customConfigFields.getFileConfiguration().set("eliteScript", (Object)configurationSection.getValues(false));
            customConfigFields.getFileConfiguration().save(customConfigFields.getFile());
        }
        catch (Exception exception) {
            Logger.warn("Failed to update old script targets! Report this to the dev.");
        }
    }

    @Generated
    public static HashMap<CustomConfigFields, EliteScriptBlueprint> getBlueprints() {
        return blueprints;
    }

    @Generated
    public CustomConfigFields getCustomConfigFields() {
        return this.customConfigFields;
    }

    @Generated
    public ScriptActionsBlueprint getScriptActionsBlueprint() {
        return this.scriptActionsBlueprint;
    }

    @Generated
    public ScriptConditionsBlueprint getScriptConditionsBlueprint() {
        return this.scriptConditionsBlueprint;
    }

    @Generated
    public ScriptZoneBlueprint getScriptZoneBlueprint() {
        return this.scriptZoneBlueprint;
    }

    @Generated
    public ScriptEventsBlueprint getScriptEventsBlueprint() {
        return this.scriptEventsBlueprint;
    }

    @Generated
    public ScriptCooldownsBlueprint getScriptCooldownsBlueprint() {
        return this.scriptCooldownsBlueprint;
    }

    @Generated
    public String getScriptName() {
        return this.scriptName;
    }

    private static class OldDataContainer {
        String location = null;
        String targetType = null;
        String offset = null;
        List<String> locations = null;
        Double range = null;
        Boolean track = null;
        String newKey;
        String scriptName;

        private OldDataContainer(String overallKey, ConfigurationSection configurationSection, String scriptName) {
            this.processMapList(configurationSection.getConfigurationSection(overallKey).getValues(false).entrySet());
            this.newKey = overallKey + ".Target";
            this.scriptName = scriptName;
            if (this.targetType != null) {
                this.updateKey("targetType", this.targetType, configurationSection);
            }
            if (this.location != null) {
                this.updateKey("location", this.location, configurationSection);
            }
            if (this.locations != null) {
                this.updateKey("locations", this.locations, configurationSection);
            }
            if (this.range != null) {
                this.updateKey("range", this.range, configurationSection);
            }
            if (this.offset != null) {
                this.updateKey("offset", this.offset, configurationSection);
            }
            if (this.track != null) {
                this.updateKey("track", this.track, configurationSection);
            }
        }

        private OldDataContainer(Map<?, ?> map, String scriptName) {
            this.processMapList(map.entrySet());
            this.scriptName = scriptName;
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            if (this.targetType != null) {
                this.updateKey("targetType", this.targetType, map, newMap);
            }
            if (this.location != null) {
                this.updateKey("location", this.location, map, newMap);
            }
            if (this.locations != null) {
                this.updateKey("locations", this.locations, map, newMap);
            }
            if (this.range != null) {
                this.updateKey("range", this.range, map, newMap);
            }
            if (this.offset != null) {
                this.updateKey("offset", this.offset, map, newMap);
            }
            if (this.track != null) {
                this.updateKey("track", this.track, map, newMap);
            }
            map.put("Target", newMap);
        }

        private void updateKey(String key, Object value, ConfigurationSection configurationSection) {
            configurationSection.set(this.newKey + "." + key, value);
            configurationSection.set(this.newKey.replace(".Target", ".") + key, null);
            if (key.contains("targetType")) {
                configurationSection.set(this.newKey.replace(".Target", ".") + key.replace("targetType", "target"), null);
            }
        }

        private void updateKey(String key, Object value, Map<String, Object> oldMap, Map<String, Object> newMap) {
            oldMap.remove(key);
            if (key.equals("targetType")) {
                oldMap.remove("target");
            }
            newMap.put(key, value);
        }

        private void processMapList(Set<Map.Entry<String, Object>> entry) {
            for (Map.Entry<String, Object> entrySet : entry) {
                String key = entrySet.getKey();
                this.processKeyAndValue(key, entrySet.getValue());
            }
        }

        protected void processKeyAndValue(String key, Object value) {
            switch (key.toLowerCase(Locale.ROOT)) {
                case "location": {
                    this.location = MapListInterpreter.parseString(key, value, this.scriptName);
                    break;
                }
                case "locations": {
                    this.locations = MapListInterpreter.parseStringList(key, value, this.scriptName);
                    break;
                }
                case "target": {
                    this.targetType = MapListInterpreter.parseString(key, value, this.scriptName);
                    break;
                }
                case "range": {
                    this.range = MapListInterpreter.parseDouble(key, value, this.scriptName);
                    break;
                }
                case "offset": {
                    this.offset = MapListInterpreter.parseString(key, value, this.scriptName);
                    break;
                }
                case "track": {
                    this.track = MapListInterpreter.parseBoolean(key, value, this.scriptName);
                }
            }
        }
    }
}

