/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests;

import com.magmaguy.elitemobs.api.QuestCompleteEvent;
import com.magmaguy.elitemobs.api.QuestLeaveEvent;
import com.magmaguy.elitemobs.config.QuestsConfig;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.objectives.QuestObjectives;
import com.magmaguy.elitemobs.utils.EventCaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.Player;

public class Quest
implements Serializable {
    protected static final HashMap<UUID, List<Quest>> pendingPlayerQuests = new HashMap();
    protected final QuestObjectives questObjectives;
    private final UUID questID = UUID.randomUUID();
    protected String questName;
    protected String questGiver = "";
    protected String questTaker = "";
    private UUID playerUUID;
    private int questLevel;
    private boolean accepted = false;

    public Quest(Player player, QuestObjectives questObjectives, int questLevel) {
        this.playerUUID = player.getUniqueId();
        this.questObjectives = questObjectives;
        this.questLevel = questLevel;
        if (pendingPlayerQuests.get(this.playerUUID) == null) {
            ArrayList<Quest> quests = new ArrayList<Quest>();
            quests.add(this);
            pendingPlayerQuests.put(this.playerUUID, quests);
        } else {
            List<Quest> quests = pendingPlayerQuests.get(this.playerUUID);
            quests.add(this);
            pendingPlayerQuests.put(this.playerUUID, quests);
        }
    }

    public static void stopPlayerQuest(Player player, String questID) {
        if (PlayerData.getQuests(player.getUniqueId()) == null || PlayerData.getQuest(player.getUniqueId(), questID) == null) {
            player.sendMessage(QuestsConfig.getLeaveWhenNoActiveQuestsExist());
            return;
        }
        QuestLeaveEvent questLeaveEvent = new QuestLeaveEvent(player, PlayerData.getQuest(player.getUniqueId(), questID));
        new EventCaller(questLeaveEvent);
    }

    public static Quest completeQuest(UUID questUUID, Player player) {
        Quest quest = PlayerData.getQuest(player.getUniqueId(), questUUID);
        if (quest == null) {
            return null;
        }
        if (!quest.getQuestID().equals(questUUID)) {
            return null;
        }
        if (!quest.getQuestObjectives().isOver()) {
            return null;
        }
        QuestCompleteEvent questCompleteEvent = new QuestCompleteEvent(player, quest);
        new EventCaller(questCompleteEvent);
        return quest;
    }

    public String getQuestTaker() {
        return this.questTaker.isEmpty() ? this.questGiver : this.questTaker;
    }

    @Generated
    public static HashMap<UUID, List<Quest>> getPendingPlayerQuests() {
        return pendingPlayerQuests;
    }

    @Generated
    public QuestObjectives getQuestObjectives() {
        return this.questObjectives;
    }

    @Generated
    public UUID getQuestID() {
        return this.questID;
    }

    @Generated
    public String getQuestName() {
        return this.questName;
    }

    @Generated
    public String getQuestGiver() {
        return this.questGiver;
    }

    @Generated
    public void setQuestGiver(String questGiver) {
        this.questGiver = questGiver;
    }

    @Generated
    public void setQuestTaker(String questTaker) {
        this.questTaker = questTaker;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Generated
    public int getQuestLevel() {
        return this.questLevel;
    }

    @Generated
    public void setQuestLevel(int questLevel) {
        this.questLevel = questLevel;
    }

    @Generated
    public boolean isAccepted() {
        return this.accepted;
    }

    @Generated
    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }
}

