/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.QuestAcceptEvent;
import com.magmaguy.elitemobs.api.QuestCompleteEvent;
import com.magmaguy.elitemobs.api.QuestProgressionEvent;
import com.magmaguy.elitemobs.config.QuestsConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.customloottable.CustomLootEntry;
import com.magmaguy.elitemobs.items.customloottable.EliteCustomLootEntry;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.objectives.CustomFetchObjective;
import com.magmaguy.elitemobs.quests.objectives.CustomKillObjective;
import com.magmaguy.elitemobs.quests.objectives.DialogObjective;
import com.magmaguy.elitemobs.quests.objectives.KillObjective;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import com.magmaguy.elitemobs.treasurechest.TreasureChest;
import com.magmaguy.elitemobs.wormhole.Wormhole;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.SpigotMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class QuestTracking {
    private static final HashMap<Player, QuestTracking> playerTrackingQuests = new HashMap();
    private final Player player;
    private final CustomQuest customQuest;
    private final List<Location> turnInNPCs = new ArrayList<Location>();
    private List<ObjectiveDestinations> objectiveDestinations = new ArrayList<ObjectiveDestinations>();
    private BukkitTask locationRefresher;
    private BukkitTask compassTask;
    private BossBar compassBar;
    private boolean questIsDone = false;

    public QuestTracking(Player player, CustomQuest customQuest) {
        this.player = player;
        this.customQuest = customQuest;
        this.startLocationGetter();
        this.startCompass();
        playerTrackingQuests.put(player, this);
        customQuest.getQuestObjectives().displayLazyObjectivesScoreboard(player);
    }

    public static boolean isTracking(Player player) {
        return playerTrackingQuests.containsKey(player);
    }

    public static void clear() {
        ((HashMap)playerTrackingQuests.clone()).values().forEach(QuestTracking::stop);
    }

    public static void toggleTracking(Player player, String questID) {
        CustomQuest customQuest = (CustomQuest)PlayerData.getQuest(player.getUniqueId(), questID);
        if (customQuest == null) {
            player.sendMessage("[EliteMobs] Failed to get a valid quest with that quest ID!");
            return;
        }
        QuestTracking.toggleTracking(player, customQuest);
    }

    public static void toggleTracking(Player player, CustomQuest quest) {
        if (playerTrackingQuests.containsKey(player)) {
            playerTrackingQuests.get(player).stop();
        } else {
            if (quest == null) {
                player.sendMessage("[EliteMobs] Failed to get a valid quest with that quest ID!");
                return;
            }
            if (!quest.getCustomQuestsConfigFields().isTrackable()) {
                return;
            }
            new QuestTracking(player, quest);
        }
    }

    public void refreshScoreboard() {
        this.customQuest.getQuestObjectives().displayLazyObjectivesScoreboard(this.player);
    }

    private void startLocationGetter() {
        this.locationRefresher = new BukkitRunnable(){

            public void run() {
                if (!QuestTracking.this.player.isValid()) {
                    QuestTracking.this.stop();
                    return;
                }
                QuestTracking.this.updateLocations(QuestTracking.this.customQuest);
            }
        }.runTaskTimerAsynchronously((Plugin)MetadataHandler.PLUGIN, 0L, 1200L);
    }

    public void updateLocations(Quest quest) {
        ArrayList<ObjectiveDestinations> destinations = new ArrayList<ObjectiveDestinations>();
        if (!quest.getQuestObjectives().isOver()) {
            this.questIsDone = false;
            for (Objective objective : quest.getQuestObjectives().getObjectives()) {
                if (objective.isObjectiveCompleted()) continue;
                if (objective instanceof CustomKillObjective) {
                    destinations.addAll(this.getKillLocations((CustomKillObjective)objective));
                    continue;
                }
                if (objective instanceof DialogObjective) {
                    destinations.addAll(this.getDialogLocations((DialogObjective)objective));
                    continue;
                }
                if (!(objective instanceof CustomFetchObjective)) continue;
                destinations.addAll(this.getFetchLocations((CustomFetchObjective)objective));
            }
            Bukkit.getScheduler().runTask((Plugin)MetadataHandler.PLUGIN, () -> {
                this.objectiveDestinations = destinations;
            });
        } else {
            this.questIsDone = true;
            this.getTurnInNPC();
        }
    }

    private List<ObjectiveDestinations> getKillLocations(CustomKillObjective customKillObjective) {
        ArrayList<ObjectiveDestinations> destinations = new ArrayList<ObjectiveDestinations>();
        ArrayList<Location> locations = new ArrayList<Location>();
        new ArrayList<EliteEntity>(EntityTracker.getEliteMobEntities().values()).forEach(eliteEntity -> {
            if (eliteEntity instanceof CustomBossEntity) {
                if (((CustomBossEntity)eliteEntity).getPhaseBossEntity() != null && ((CustomBossEntity)eliteEntity).getPhaseBossEntity().getPhase1Config().getFilename().equals(customKillObjective.getCustomBossFilename())) {
                    locations.add(eliteEntity.getLocation());
                } else if (((CustomBossEntity)eliteEntity).getCustomBossesConfigFields().getFilename().equals(customKillObjective.getCustomBossFilename())) {
                    locations.add(eliteEntity.getLocation());
                }
            }
        });
        destinations.add(new ObjectiveDestinations(customKillObjective, locations));
        return destinations;
    }

    private List<ObjectiveDestinations> getDialogLocations(DialogObjective dialogObjective) {
        ArrayList<ObjectiveDestinations> destinations = new ArrayList<ObjectiveDestinations>();
        EntityTracker.getNpcEntities().values().forEach(npcEntity -> {
            ArrayList<Location> locations = new ArrayList<Location>();
            if (npcEntity.getNPCsConfigFields().getFilename().equals(dialogObjective.getNpcFilename())) {
                locations.add(npcEntity.getSpawnLocation());
            }
            destinations.add(new ObjectiveDestinations(dialogObjective, locations));
        });
        return destinations;
    }

    private List<ObjectiveDestinations> getFetchLocations(CustomFetchObjective customFetchObjective) {
        ArrayList<ObjectiveDestinations> destinations = new ArrayList<ObjectiveDestinations>();
        ArrayList<Location> locations = new ArrayList<Location>();
        new ArrayList<EliteEntity>(EntityTracker.getEliteMobEntities().values()).forEach(eliteEntity -> {
            if (eliteEntity instanceof CustomBossEntity) {
                CustomBossEntity customBossEntity = (CustomBossEntity)eliteEntity;
                for (CustomLootEntry customLootEntry : customBossEntity.getCustomBossesConfigFields().getCustomLootTable().getEntries()) {
                    EliteCustomLootEntry eliteCustomLootEntry;
                    if (!(customLootEntry instanceof EliteCustomLootEntry) || !(eliteCustomLootEntry = (EliteCustomLootEntry)customLootEntry).getFilename().equals(customFetchObjective.getKey())) continue;
                    locations.add(eliteEntity.getLocation());
                }
            }
        });
        new ArrayList<TreasureChest>(TreasureChest.getTreasureChestHashMap().values()).forEach(treasureChest -> {
            for (CustomLootEntry customLootEntry : treasureChest.getCustomTreasureChestConfigFields().getCustomLootTable().getEntries()) {
                EliteCustomLootEntry eliteCustomLootEntry;
                if (!(customLootEntry instanceof EliteCustomLootEntry) || !(eliteCustomLootEntry = (EliteCustomLootEntry)customLootEntry).getFilename().equals(customFetchObjective.getKey())) continue;
                locations.add(treasureChest.getLocation());
            }
        });
        destinations.add(new ObjectiveDestinations(customFetchObjective, locations));
        return destinations;
    }

    private void getTurnInNPC() {
        EntityTracker.getNpcEntities().values().forEach(npcEntity -> {
            if (npcEntity.getNPCsConfigFields().getFilename().equals(this.customQuest.getQuestTaker())) {
                this.turnInNPCs.add(npcEntity.getSpawnLocation());
            }
        });
    }

    public void stop() {
        playerTrackingQuests.remove(this.player);
        new BukkitRunnable(){

            public void run() {
                QuestTracking.this.player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
            }
        }.runTask((Plugin)MetadataHandler.PLUGIN);
        this.locationRefresher.cancel();
        this.compassTask.cancel();
        this.compassBar.removeAll();
    }

    private void startCompass() {
        this.compassBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.PLAY_BOSS_MUSIC});
        this.compassTask = new BukkitRunnable(){

            public void run() {
                if (!QuestTracking.this.player.isOnline()) {
                    QuestTracking.this.stop();
                    return;
                }
                QuestTracking.this.updateCompassContents();
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void updateCompassContents() {
        Object compassText = "---------------------------------------------------------------";
        List<LocationAndSymbol> locationAndSymbols = this.projectLocations();
        if (!locationAndSymbols.isEmpty()) {
            for (LocationAndSymbol pair : locationAndSymbols) {
                compassText = ((String)compassText).substring(0, pair.getKey()) + pair.getValue() + ((String)compassText).substring(pair.getKey() + 1);
            }
        } else {
            World world = null;
            boolean locationsOutOfBounds = false;
            ArrayList<ObjectiveDestinations> tempDestinations = new ArrayList<ObjectiveDestinations>(this.objectiveDestinations);
            block1: for (ObjectiveDestinations destinations : tempDestinations) {
                for (Location location : destinations.getDestinations()) {
                    if (location == null || location.getWorld() == null || !(world = location.getWorld()).equals(this.player.getWorld())) continue;
                    locationsOutOfBounds = true;
                    continue block1;
                }
            }
            if (!locationsOutOfBounds) {
                if (world != null) {
                    boolean wormholeIsViable = false;
                    for (Wormhole wormhole : Wormhole.getWormholes()) {
                        LocationAndSymbol pair;
                        if (wormhole.getWormholeEntry1().getLocation() != null && wormhole.getWormholeEntry1().getLocation().getWorld() != null && wormhole.getWormholeEntry1().getLocation().getWorld().equals(this.player.getWorld())) {
                            if (wormhole.getWormholeEntry2().getLocation() == null || wormhole.getWormholeEntry2().getLocation().getWorld() == null || !wormhole.getWormholeEntry2().getLocation().getWorld().equals(world)) continue;
                            pair = this.processLocations(wormhole.getWormholeEntry1().getLocation(), null);
                            if (pair != null) {
                                compassText = ((String)compassText).substring(0, pair.getKey()) + pair.getValue() + ((String)compassText).substring(pair.getKey() + 1);
                            }
                            wormholeIsViable = true;
                            continue;
                        }
                        if (wormhole.getWormholeEntry2().getLocation() == null || wormhole.getWormholeEntry2().getLocation().getWorld() == null || !wormhole.getWormholeEntry2().getLocation().getWorld().equals(this.player.getWorld()) || wormhole.getWormholeEntry1().getLocation() == null || wormhole.getWormholeEntry1().getLocation().getWorld() == null || !wormhole.getWormholeEntry1().getLocation().getWorld().equals(world)) continue;
                        pair = this.processLocations(wormhole.getWormholeEntry2().getLocation(), null);
                        if (pair != null) {
                            compassText = ((String)compassText).substring(0, pair.getKey()) + pair.getValue() + ((String)compassText).substring(pair.getKey() + 1);
                        }
                        wormholeIsViable = true;
                    }
                    if (!wormholeIsViable) {
                        compassText = QuestsConfig.getQuestDestinationInOtherWorld().replace("$world", world.getName());
                    }
                } else {
                    compassText = QuestsConfig.getNoQuestDestinationFound();
                }
            }
        }
        this.compassBar.setTitle((String)compassText);
        this.compassBar.addPlayer(this.player);
    }

    private List<LocationAndSymbol> projectLocations() {
        ArrayList<LocationAndSymbol> parsedVectors = new ArrayList<LocationAndSymbol>();
        if (this.questIsDone) {
            for (Location location : new ArrayList<Location>(this.turnInNPCs)) {
                LocationAndSymbol locationAndSymbol = this.processLocations(location, null);
                if (locationAndSymbol == null) continue;
                parsedVectors.add(locationAndSymbol);
            }
        } else {
            for (ObjectiveDestinations iteratedObjectiveDestinations : new ArrayList<ObjectiveDestinations>(this.objectiveDestinations)) {
                for (Location location : iteratedObjectiveDestinations.getDestinations()) {
                    LocationAndSymbol locationAndSymbol = this.processLocations(location, iteratedObjectiveDestinations.getObjective());
                    if (locationAndSymbol == null) continue;
                    parsedVectors.add(locationAndSymbol);
                }
            }
        }
        return parsedVectors;
    }

    private LocationAndSymbol processLocations(Location location, Objective objective) {
        if (this.player.getWorld().equals(location.getWorld())) {
            Vector toTarget = this.toTargetVector(this.player, location);
            double angle = this.getAngle(toTarget, this.player);
            if (Math.abs(angle) > 1.5707963267948966) {
                return null;
            }
            return new LocationAndSymbol((int)(angle * 57.0 / 3.0), this.getSymbol(objective));
        }
        return null;
    }

    private Vector toTargetVector(Player player, Location location) {
        return location.clone().add(new Vector(0.0, 1.85, 0.0)).subtract(player.getEyeLocation()).toVector().normalize();
    }

    private double getAngle(Vector toTarget, Player player) {
        double angle = player.getEyeLocation().getDirection().setY(0).angle(toTarget.clone().setY(0));
        if (toTarget.getX() * player.getEyeLocation().getDirection().getZ() - toTarget.getZ() * player.getEyeLocation().getDirection().getX() > 0.0) {
            angle *= -1.0;
        }
        return angle;
    }

    private String getSymbol(Objective objective) {
        if (objective == null) {
            return "\u2b2f";
        }
        if (this.questIsDone) {
            return "\u29bf";
        }
        if (objective instanceof KillObjective) {
            return "\u2620";
        }
        if (objective instanceof DialogObjective) {
            return "\u29bf";
        }
        if (objective instanceof CustomFetchObjective) {
            return "\u2694";
        }
        return "\u29bf";
    }

    @Generated
    public static HashMap<Player, QuestTracking> getPlayerTrackingQuests() {
        return playerTrackingQuests;
    }

    @Generated
    public CustomQuest getCustomQuest() {
        return this.customQuest;
    }

    private class ObjectiveDestinations {
        private final Objective objective;
        private final List<Location> destinations;

        private ObjectiveDestinations(Objective objective, List<Location> destinations) {
            this.objective = objective;
            this.destinations = destinations;
            QuestTracking.this.objectiveDestinations.add(this);
        }

        @Generated
        public Objective getObjective() {
            return this.objective;
        }

        @Generated
        public List<Location> getDestinations() {
            return this.destinations;
        }
    }

    private class LocationAndSymbol {
        private final int key;
        private final String value;

        private LocationAndSymbol(int key, String value) {
            this.key = key + 31;
            this.value = value;
        }

        @Generated
        public int getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class QuestTrackingEvents
    implements Listener {
        @EventHandler
        public void onPlayerLogout(PlayerQuitEvent event) {
            QuestTracking questTracking = QuestTracking.getPlayerTrackingQuests().get(event.getPlayer());
            if (questTracking == null) {
                return;
            }
            questTracking.stop();
        }

        @EventHandler(ignoreCancelled=true)
        public void onQuestProgressEvent(QuestProgressionEvent event) {
            if (!QuestTracking.isTracking(event.getPlayer())) {
                return;
            }
            if (!QuestTracking.getPlayerTrackingQuests().get(event.getPlayer()).getCustomQuest().getQuestID().equals(event.getQuest().getQuestID())) {
                return;
            }
            QuestTracking.getPlayerTrackingQuests().get(event.getPlayer()).updateLocations(QuestTracking.getPlayerTrackingQuests().get(event.getPlayer()).getCustomQuest());
            QuestTracking.getPlayerTrackingQuests().get(event.getPlayer()).refreshScoreboard();
        }

        @EventHandler(ignoreCancelled=true)
        public void onQuestCompleteEvent(QuestCompleteEvent event) {
            if (!QuestTracking.isTracking(event.getPlayer())) {
                return;
            }
            if (!QuestTracking.getPlayerTrackingQuests().get(event.getPlayer()).getCustomQuest().getQuestID().equals(event.getQuest().getQuestID())) {
                return;
            }
            QuestTracking.getPlayerTrackingQuests().get(event.getPlayer()).stop();
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onQuestAcceptEvent(QuestAcceptEvent event) {
            if (!(event.getQuest() instanceof CustomQuest)) {
                return;
            }
            if (!((CustomQuest)event.getQuest()).getCustomQuestsConfigFields().isTrackable()) {
                return;
            }
            if (QuestsConfig.isAutoTrackQuestsOnAccept()) {
                QuestTracking.toggleTracking(event.getPlayer(), (CustomQuest)event.getQuest());
                event.getPlayer().spigot().sendMessage((BaseComponent)SpigotMessage.commandHoverMessage(ChatColorConverter.convert(QuestsConfig.getChatTrackingMessage()), ChatColorConverter.convert(QuestsConfig.getChatTrackingHover()), QuestsConfig.getChatTrackingCommand().replace("$questID", event.getQuest().getQuestID().toString())));
            } else {
                event.getPlayer().spigot().sendMessage((BaseComponent)SpigotMessage.commandHoverMessage(ChatColorConverter.convert(QuestsConfig.getChatTrackMessage()), ChatColorConverter.convert(QuestsConfig.getChatTrackHover()), QuestsConfig.getChatTrackCommand().replace("$questID", event.getQuest().getQuestID().toString())));
            }
        }
    }
}

