/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.objectives;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.QuestAcceptEvent;
import com.magmaguy.elitemobs.api.QuestCompleteEvent;
import com.magmaguy.elitemobs.api.QuestProgressionEvent;
import com.magmaguy.elitemobs.api.QuestRewardEvent;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import com.magmaguy.elitemobs.quests.objectives.QuestObjectives;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.Logger;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class CustomFetchObjective
extends Objective {
    private final String key;
    private boolean readyToPickUp = false;
    private boolean requireItemTurnIn;

    public CustomFetchObjective(int targetAmount, String objectiveName, String customItemFilename) {
        super(targetAmount, objectiveName);
        this.key = customItemFilename;
    }

    private static void checkEvent(@NotNull Player player, @NotNull ItemStack itemStack) {
        for (Quest quest : PlayerData.getQuests(player.getUniqueId())) {
            for (Objective objective : quest.getQuestObjectives().getObjectives()) {
                if (!(objective instanceof CustomFetchObjective)) continue;
                ((CustomFetchObjective)objective).checkItem(player, itemStack, quest.getQuestObjectives());
            }
        }
    }

    private void checkItem(Player player, @NotNull ItemStack itemStack, QuestObjectives questObjectives) {
        if (!ItemTagger.hasKey(itemStack, this.key)) {
            return;
        }
        this.progressNonlinearObjective(questObjectives, player);
    }

    private void turnItemsIn(Player player) {
        int deletedItems = 0;
        for (ItemStack itemStack : player.getInventory()) {
            int missingAmount;
            if (!ItemTagger.hasKey(itemStack, this.key)) continue;
            int existingAmount = itemStack.getAmount();
            if (existingAmount >= (missingAmount = this.targetAmount - deletedItems)) {
                existingAmount -= missingAmount;
                deletedItems += missingAmount;
            } else {
                existingAmount = 0;
            }
            itemStack.setAmount(existingAmount);
            if (deletedItems != this.targetAmount) continue;
            return;
        }
        Logger.warn("Player " + player.getName() + " managed to complete objective " + this.objectiveName + " without turning in the required amount of items! This isn't good, tell the developer!");
    }

    @Override
    public void progressNonlinearObjective(final QuestObjectives questObjectives, final Player player) {
        final CustomFetchObjective customFetchObjective = this;
        new BukkitRunnable(){

            public void run() {
                CustomFetchObjective.this.fullUpdate(player);
                if (questObjectives.isTurnedIn()) {
                    return;
                }
                CustomFetchObjective.this.objectiveCompleted = CustomFetchObjective.this.currentAmount >= CustomFetchObjective.this.targetAmount;
                QuestProgressionEvent questProgressionEvent = new QuestProgressionEvent(Bukkit.getPlayer((UUID)questObjectives.getQuest().getPlayerUUID()), questObjectives.getQuest(), customFetchObjective);
                new EventCaller(questProgressionEvent);
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
    }

    private void fullUpdate(Player player) {
        this.currentAmount = 0;
        for (ItemStack itemStack : player.getInventory()) {
            if (!ItemTagger.hasKey(itemStack, this.key)) continue;
            this.currentAmount += itemStack.getAmount();
        }
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public boolean isReadyToPickUp() {
        return this.readyToPickUp;
    }

    @Generated
    public void setReadyToPickUp(boolean readyToPickUp) {
        this.readyToPickUp = readyToPickUp;
    }

    @Generated
    public boolean isRequireItemTurnIn() {
        return this.requireItemTurnIn;
    }

    public static class CustomFetchObjectiveEvents
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onItemDrop(PlayerDropItemEvent event) {
            CustomFetchObjective.checkEvent(event.getPlayer(), event.getItemDrop().getItemStack());
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onItemPickup(EntityPickupItemEvent event) {
            if (event.getEntity().getType() != EntityType.PLAYER) {
                return;
            }
            CustomFetchObjective.checkEvent((Player)event.getEntity(), event.getItem().getItemStack());
        }

        @EventHandler(ignoreCancelled=true)
        public void onQuestAcceptEvent(QuestAcceptEvent event) {
            for (Objective objective : event.getQuest().getQuestObjectives().getObjectives()) {
                if (!(objective instanceof CustomFetchObjective)) continue;
                objective.progressNonlinearObjective(event.getQuest().getQuestObjectives(), event.getPlayer());
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onQuestCompleteEvent(QuestCompleteEvent event) {
            for (Objective objective : event.getQuest().getQuestObjectives().getObjectives()) {
                if (!(objective instanceof CustomFetchObjective)) continue;
                objective.progressNonlinearObjective(event.getQuest().getQuestObjectives(), event.getPlayer());
                if (objective.getCurrentAmount() >= objective.getTargetAmount()) continue;
                event.setCancelled(true);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onQuestRewardEvent(QuestRewardEvent event) {
            for (Objective objective : event.getQuest().getQuestObjectives().getObjectives()) {
                if (!(objective instanceof CustomFetchObjective)) continue;
                ((CustomFetchObjective)objective).turnItemsIn(event.getPlayer());
            }
        }
    }
}

