/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.objectives;

import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import com.magmaguy.elitemobs.quests.objectives.QuestObjectives;
import java.util.List;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;

public class DialogObjective
extends Objective {
    private final String targetLocation;
    private final String npcFilename;
    private final List<String> dialog;

    public DialogObjective(String npcFilename, String npcName, String targetLocation, List<String> dialog) {
        super(1, npcName);
        this.targetLocation = targetLocation;
        this.npcFilename = npcFilename;
        this.dialog = dialog;
    }

    public boolean checkProgress(Player player, QuestObjectives questObjectives) {
        if (this.currentAmount >= this.targetAmount) {
            return false;
        }
        this.progressObjective(questObjectives);
        this.dialog.forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
        return true;
    }

    @Generated
    public String getTargetLocation() {
        return this.targetLocation;
    }

    @Generated
    public String getNpcFilename() {
        return this.npcFilename;
    }

    @Generated
    public List<String> getDialog() {
        return this.dialog;
    }

    public static class DialogObjectiveEvents
    implements Listener {
        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public void onInteract(PlayerInteractAtEntityEvent event) {
            NPCEntity npcEntity = EntityTracker.getNPCEntity(event.getRightClicked());
            if (npcEntity == null) {
                return;
            }
            for (Quest quest : PlayerData.getQuests(event.getPlayer().getUniqueId())) {
                for (Objective objective : quest.getQuestObjectives().getObjectives()) {
                    if (!(objective instanceof DialogObjective) || !((DialogObjective)objective).getNpcFilename().equals(npcEntity.getNPCsConfigFields().getFilename()) || !((DialogObjective)objective).checkProgress(event.getPlayer(), quest.getQuestObjectives())) continue;
                    event.setCancelled(true);
                }
            }
        }
    }
}

